<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/18
 * Time: 11:53 AM
 */

namespace kmkj\common;


class Cookie
{

    protected  $isSwoole =false;
    public function __construct()
    {
        if(class_exists('\EasySwoole\EasySwoole\Config')){
            $this->isSwoole =true;
        }
    }

    /**
     * @link https://www.php.net/manual/zh/function.setcookie.php
     * @param $name
     * @param $value
     * @param int $expire
     * @param string $path
     * @param string $domain
     * @param bool $secure
     * @User: 阿豹
     * @Date: 2020/4/18
     */
    public function set($name, $value, $expire=0, $path='/', $domain='/', $secure=false){

        $args = [ $name, $value, $expire, $path, $domain, $secure];
        if (!$this->isSwoole) {
            return call_user_func_array('setcookie',$args);
        }
        ;
        if ( class_exists('\App\Common\Helper\CoDiHelper',false) && \App\Common\Helper\CoDiHelper::get('response'))
        {
            return call_user_func_array([ \App\Common\Helper\CoDiHelper::get('response') ,'setCookie'],$args);
        }

    }

    /**
     * 获取cookie
     * @param $key
     * @param $defualut
     * @return bool|mixed
     * @User: 阿豹
     * @Date: 2020/4/18
     */
    public function get($key,$defualut=null){
        if (!$this->isSwoole) {
           return isset($_COOKIE[$key])?$_COOKIE[$key]:$defualut;
        }
        if ( class_exists('\App\Common\Helper\CoDiHelper',false) && \App\Common\Helper\CoDiHelper::get('request'))
        {
            $res=  call_user_func_array([ \App\Common\Helper\CoDiHelper::get('request'),'getCookieParams'],[$key]);
            if (!$res) {
                $res = $defualut;
            }
            return $res;
        }
        return $defualut;

    }
}