<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 10:12 AM
 */

namespace kmkj\JournalModule\core;

use kmkj\common\objectAsArray;
use kmkj\JournalModule\header\journalConst;
use kmkj\log\handler\LogHandler;

abstract class BaseJournalModule implements \ArrayAccess
{
    use objectAsArray;


    /**
     * 提交数据到阿里云的操作类
     * @var LogHandler
     */
    private static $logHandler;
    private $logConfig=journalConst::PROJECT_NAME_EASySWOOLE;

    public function getLogConfig(){
        return $this->logConfig;
    }

    public function setLogConfig($config)
    {
        $this->logConfig =$config;
        return $config;
    }
    /**
     * @var string 所属项目
     */
    protected static $_project;

    protected $_hasSuccess=1;
    /**
     * @var string 创建时间 时间戳
     */
    protected $_creteTime;
    /**
     * @var string 创建的年月日 YYY-MM-DD
     */
    protected $_creteDate;
    /**
     * @var string 服务器的主机名称
     */
    protected $_hostName;

    /**
     * 请求ID
     * @var string
     */
    protected $_requestId = '';

    private $data;

    public function __construct()
    {
        if (!self::$_project){
            $this->setProject();
        }
        $this->_creteDate = date("Y-m-d");
        $this->_creteTime = time();
        $this->_hostName = gethostname();
        $this->requestId =  uniqid('',true).mt_rand(1000000,9000000);
    }

    public function getProject(){
        return self::$_project;
    }

    /**
     * 设置所属项目
     * @return $this
     */
    public function setProject()
    {
        $pr='debug';
        if (class_exists('\EasySwoole\EasySwoole\Config')){
            $pr = journalConst::PROJECT_NAME_EASySWOOLE;
        } elseif (defined('THINK_VERSION') && THINK_VERSION === '3.2.3'){
            $pr = journalConst::PROJECT_NAME_TP32;
        }else {
            $pr = journalConst::PROJECT_NAME_TP51;
        }
        self::$_project = $pr;
       return $this;
    }

    public function setIsError(){
        $this->_hasSuccess = 0;
        return $this;
    }


    public function getAttributeAsArr(){
        $arr = (array)$this;
        $ret= [];
        foreach ($arr as $key =>$value) {
            if (strpos($key,'JournalModule')!==false) {
                continue;
            }
            if ($key{1} == '*') {
                $key = substr($key,3);
            }
            if($key == 'keyMap') continue;
            $ret[$key] = $value;
        }
        return $ret;
    }

    /**
     * 获取日志上传对象
     * @return LogHandler
     */
    public function getLogHandler()
    {
        if (empty(self::$logHandler)) {
            self::$logHandler = new LogHandler($this->getLogConfig());
        }
        return self::$logHandler;
    }

    /**
     * 将写入的数据和搜集到的数据合并起来
     * @param $data
     * @return array
     */
    protected function mergeData($data){
        if (!is_array($data)) {
            $data = ['data' => (string) $data];
        }
        $data = array_merge($this->getAttributeAsArr(),$data);
        return $data;
    }
    /**
     * 记录一条info级别的日志
     * @param $msg
     * @param array $data
     * @param string $logName
     */
    public function info($msg,$data=[],$logName='add'){
        $data = $this->mergeData($data);
        $this->getLogHandler()->addAliLog($msg,$data,journalConst::INFO,$logName,$this->getProject());
    }

    /**
     * 记录一条debug的错误日志
     * @param $msg
     * @param array $data
     * @param string $logName
     */
    public function debug($msg,$data=[],$logName='add')
    {
        $arr = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,2);
        $data = $this->mergeData($data);
        $data['_FILE_'] = isset($arr[1]['file']) ? $arr[1]['file'] : '';
        $data['_LINE_'] = isset($arr[1]['line']) ? $arr[1]['line'] : '';
        $data['_FUNCTION_'] = isset($arr[1]['function']) ? $arr[1]['function'] : '';
        $res = $this->getLogHandler()->addAliLog($msg,$data,journalConst::DEBUG,$logName,$this->getProject());
    }

    /**
     * 记录一条错误日志
     * @param $msg
     * @param array $data
     * @param string $logName
     */
    public function error($msg,$data=[],$logName='add'){
        $arr = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,2);
        $data = $this->mergeData($data);
        $data['_FILE_'] = isset($arr[1]['file']) ? $arr[1]['file'] : '';
        $data['_LINE_'] = isset($arr[1]['line']) ? $arr[1]['line'] : '';
        $data['_FUNCTION_'] = isset($arr[1]['function']) ? $arr[1]['function'] : '';
        $data = $this->mergeData($data);
        $this->getLogHandler()->addAliLog($msg,$data,journalConst::ERROR,$logName,$this->getProject());

    }

    /**
     * 将设置在 data的属性提交到阿里云
     * 刷新日志出去
     * @param $msg
     * @param $level
     * @param string $logName
     */
    public function flushLog($msg,$level,$logName='add'){
        $data = $this->getData();
        $method = [100 => 'debug', 200 => 'info', 400 => 'error'];
        $this->{$method[$level]}($msg,$data,$logName);
        $this->setData([]);
    }



    public function setData($data){
        $this->data =  $data;
        return $this;
    }
    public function getData(){
        return $this->data;
    }
}