<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 2:43 PM
 */

namespace kmkj\JournalModule\core\request;


use kmkj\JournalModule\interfaces\WebUser;

class WebUserJournalModule extends BaseRequestJournalModule implements WebUser
{
    protected $_name='webuser';
    /**
     * @var int  微信客户ID
     */
    protected $_wechatId =0;
    /**
     * @var int  uid
     */
    protected $_uid =0;

    /**
     * @var string 请求的token
     */
    protected $_token='';
    /**
     * @var string post请求的包体
     */
    protected $_body='';
    /**
     * @var string 用户来源的域名
     */
    protected $_fromDomain='';
    /**
     * @var int 应用ID
     */
    protected $_appId=0;

    public function setWeChatId($weChatId)
    {
        $this->_wechatId = (int)$weChatId;
        return $this;
    }

    public function setUid($uid)
    {
        $this->_uid = (int)$uid;
        return $this;
    }

    public function setToken($token)
    {
        $this->_token = $token;
        return $this;
    }


    public function setBody($body)
    {
        $this->_body = $body;
        return $this;
    }

    public function setFromDomain($domain)
    {
        $this->_fromDomain = $domain;
        return $this;
    }

    public function setAppId($appId)
    {
        $this->_appId = (int)$appId;
        return $this;
    }


}