<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/2/24
 * Time: 17:05
 */
namespace kmkj\log\ali;
use kmkj\common\Config;

/**
 * 阿里云日志基础类
 * Class LogClient
 * @author xiaozhou
 * @link https://help.aliyun.com/document_detail/29074.html
 * @package kmkj\log\ali
 */

class LogClient {

    protected $client;

    protected $project;
    protected $kmkjProject;

    public $logStore;

    public function init($conf = [])
    {
        if (empty($conf)) {
            $conf = $this->getConfig($conf);
        }
        try{
            $this->client = new \Aliyun_Log_Client($conf['endpoint'],$conf['accessId'],$conf['accessKey']);
            $this->project = $conf['project'];
            $this->logStore = $conf['logStore'];

            //列出当前project下的所有日志库名称
            /*
            $req = new Aliyun_Log_Models_ListLogstoresRequest($conf['project']);
            $res1 = $client->listLogstores($req);
            */
        }catch (\Exception $e){
            $this->errorLog($e->getMessage());
        }
    }

    /**
     * @return \Aliyun_Log_Client
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * 获取阿里去云配置参数
     * @param string $conf
     * @return array
     */
    public function getConfig( $conf = 'log')
    {
        if (empty($conf)) {
            $conf = 'log';
        }
        if (!is_string($conf)) {
            return (array)$conf;
        }
        $conf = new Config($conf,'ali');
        $ret['endpoint'] = $conf->getConfig('endpoint');
        $ret['accessId'] = $conf->getConfig('accessId');
        $ret['accessKey'] = $conf->getConfig('accessKey');
        $ret['project'] = $conf->getConfig('project');
        $ret['logstore'] = $conf->getConfig('logstore');
    }

    /**
     * 获取RunTime目录
     * @return string
     */
    protected function getRunTimePath()
    {
        $runTimePath = './';
        if(function_exists('M') &&function_exists('A') && function_exists('G')){
            $runTimePath= APP_PATH.'Runtime/';
        }elseif (class_exists('think\app')){
            $runTimePath = \think\facade\App::getRuntimePath()."/";
        }
        return $runTimePath;
    }

    /**
     * 写错误日志
     * @param $msg
     * @param string $fileName
     */
    public function errorLog($msg,$fileName='LogError.log')
    {
        $runTimePath= $this->getRunTimePath();
        $aa = debug_backtrace(10);
        error_log(date("Y-m-d H:i:s").$msg."\t".json_encode($aa,JSON_UNESCAPED_UNICODE)."\n",3,$runTimePath.$fileName);
    }
}