<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/2/24
 * Time: 16:51
 */

namespace kmkj\log\handler;

use kmkj\common\Config;
use kmkj\JournalModule\header\journalConst;
use kmkj\log\ali\LogClient;

class LogHandler extends LogClient
{

    public function __construct($config='')
    {
        $this->init($config);
    }
    /**
     * 写入日志
     * @param $msg string 描述信息
     * @param $content array 日志内容
     * @param $level  int 级别 debug info ...
     * @param $logName  string 业务名称(操作类型,如：add,debug,info)
     * @param $topic string 自定义topic(如模块)
     * @param string $source 来源
     * @return bool|array
     */
    public function addAliLog($msg = '', $content = [], $level = Logger::INFO, $logName = 'add', $topic = '', $source = 'source')
    {
        if(!is_array($content)){
            $content = ['data'=>(string) $content];
        }

        $contents = [
            'msg'       => $msg,
            '_level'     => $level
        ];

        //多维数组处理
        foreach ($content as &$value){
            if(is_array($value)){
                $value = json_encode($value,JSON_UNESCAPED_UNICODE);
            }
        }

        $contents = array_merge($contents, $content);
        $logitems = array();
        $logItem = new \Aliyun_Log_Models_LogItem();
        $logItem->setTime(time());
        $logItem->setContents($contents);
        array_push($logitems, $logItem);
        $this->logStore = journalConst::$logLevelName[$level];
        // 如果是debug的日志那么久写入到 logdev的项目里面去
        $project= $this->project;
        if ($level == Logger::DEBUG) {
            $project = $this->debugProject;
        }
        $req = new \Aliyun_Log_Models_PutLogsRequest($project, $this->logStore, $topic, $source, $logitems);
        if ($this->isConfigOk) {
            try {
               $res = $this->getClient()->putLogs($req);
                return $res ;
            } catch (\Exception $exception) {
                $this->putFileLog($req,$level);
                $this->setError($exception);
            }
        }
        return false;
    }


    /**
     * @param $logObj \Aliyun_Log_Models_PutLogsRequest
     * @User: 阿豹
     * @Date: 2020/4/17
     */
    protected function putFileLog($logObj,$level){
        $eof = "\t\t";
        $str = date("Y-m-d H:i:s") . $eof;
        $str .= $logObj->getProject() . $eof;
        $str .= json_encode($logObj->getLogItems(),JSON_UNESCAPED_UNICODE) . $eof;
        $str .= $logObj->getLogstore() . $eof;
        $str .= $logObj->getTopic() . $eof;
        $str .= $logObj->getSource() . $eof;
        $file = $this->getRunTimePath()."/log_downgrade_{$level}.log";
        file_put_contents($file,$str,true);
    }

    /**
     * 查询日志数据
     * @param array $logitems
     * @param $topic
     * @param string $source
     */
    public function queryAliLogs($query = '', $from = '', $to = '', $topic = '')
    {
        //$this->initQuery();
        $project = $this->project;
        $logstore = $this->logStore;

        //查询日志数据
        $from = $from ? $from : time()-3600;
        $to = $to ? $to : time();
        $res = NULL;
        while (is_null($res) || (! $res->isCompleted()))
        {
            $req = new \Aliyun_Log_Models_GetLogsRequest($project, $logstore, $from, $to, $topic, $query, 5, 0, False);
            $res = $this->getClient()->getLogs($req);
        }
        return $res;
    }

    /**
     * 采集数据初始化
     * @param array $logitems
     * @param $topic
     * @param string $source
     */
    protected function initQuery()
    {
        $project = $this->project;
        $logstore = $this->logStore;
        $client = $this->getClient();

        //首先遍历有哪些shardId
        $listShardRequest = new \Aliyun_Log_Models_ListShardsRequest($project,$logstore);
        $listShardResponse = $client -> listShards($listShardRequest);
        foreach($listShardResponse-> getShardIds()  as $shardId)
        {
            //对每一个ShardId，先获取Cursor
            $getCursorRequest = new \Aliyun_Log_Models_GetCursorRequest($project,$logstore,$shardId,null, time() - 60);
            $response = $client -> getCursor($getCursorRequest);
            $cursor = $response-> getCursor();
            $count = 100;
            while(true)
            {
                //从cursor开始读数据
                $batchGetDataRequest = new \Aliyun_Log_Models_BatchGetLogsRequest($project,$logstore,$shardId,$count,$cursor);
                $response = $client -> batchGetLogs($batchGetDataRequest);
                if($cursor == $response -> getNextCursor())
                {
                    break;
                }
                $logGroupList = $response -> getLogGroupList();
                foreach($logGroupList as $logGroup)
                {
                    print ($logGroup->getCategory());
                    foreach($logGroup -> getLogsArray() as $log)
                    {
                        foreach($log -> getContentsArray() as $content)
                        {
                            print($content-> getKey().":".$content->getValue()."\t");
                        }
                        print("\n");
                    }
                }
                $cursor = $response -> getNextCursor();
            }
        }
        //等待1分钟后对日志进行查询
        sleep(60);
        return true;
    }

}