<?php


namespace kmkj\JournalModule\core\request;

use kmkj\JournalModule\header\journalConst;
use kmkj\JournalModule\interfaces\Admin;

class AdminJournalModel extends BaseRequestJournalModule implements Admin {
    /**
     * @var string 日志名称
     */
    protected $logName = 'admin';
    /**
     * @var string 管理员id
     */
    protected $adminId = '';
    /**
     * @var array|string 管理应用id集合
     */
    protected $appIds = '';
    /**
     * @var string  请求路由名称
     */
    protected $memu = '';
    /**
     * @var array 修改前数据
     */
    protected $beforeData = [];
    /**
     * @var array 修改数据
     */
    protected $updateData = [];
    /**
     * @var string post请求的包体
     */
    protected $_body='';
    /**
     * @var bool 是否需要记录请求参数与返回数据
     */
    protected $needRecordResponse = false;
    
    public function __construct() {
        parent::__construct();
        $this->memu = $this->getMenu();
        $this->appIds = $this->getAppIds();
    }
    
    public function setAdminId($adminId) {
        $this->adminId = $adminId;
        return $this;
    }
    
    public function getAdminId() {
        return $this->adminId;
    }
    
    public function setBeforeUpdateData($data) {
        // TODO: Implement setBeforeUpdateData() method.
        $this->beforeData = $data;
        return $this;
    }
    
    public function setUpdateData($data) {
        // TODO: Implement setUpdateData() method.
        $this->updateData = $data;
        return $this;
    }
    
    public function setAppIds($appIds) {
        $this->appIds = $appIds;
        return $this;
        // TODO: Implement setAppId() method.
    }
    
    public function getAppIds() {
        // TODO: Implement getAppId() method.
        if (!empty($this->appIds)) return $this->appIds;
        if ($this->getProject() == journalConst::PROJECT_NAME_TP51) {
            $apps_id = empty($_REQUEST['app_id']) ? '' : $_REQUEST['app_id'];
            if (!empty($apps_id) || ($apps_id = empty($_REQUEST['app_ids']) ? '' : $_REQUEST['app_ids'])) {
                $apps_id = array_map(function ($item) {
                    return \app\common\helper\Lib::decryptionId($item);
                }, explode(',', $apps_id));
            }
            return $apps_id;
        }
    }
    
    public function setMenu($menu) {
        // TODO: Implement setMenu() method.
        $this->memu = $menu;
        return $this;
    }
    
    public function getMenu() {
        // TODO: Implement getMenu() method.
        if (!empty($this->memu)) return $this->memu;
        if ($this->getProject() == journalConst::PROJECT_NAME_TP51) {
            return empty($_REQUEST['routerName']) ? '' : $_REQUEST['routerName'];
        }
    }
    
    /**
     * 设置是否需要记录响应结果
     * @param $bool
     * @return $this
     * @User: 阿豹
     * @Date: 2020/4/18
     */
    public function needRecordResponse($bool)
    {
        $this->needRecordResponse = $bool;
        return $this;
    }
    
    /**
     * 获取是否需要记录响应结果状态
     * @return bool
     */
    public function getNeedRecordResponse(){
        return $this->needRecordResponse;
    }
    
}