<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 11:24 AM
 */

namespace kmkj\JournalModule\core\request;


use App\Common\Helper\CoDiHelper;
use kmkj\JournalModule\core\BaseJournalModule;
use kmkj\JournalModule\header\journalConst;

class BaseRequestJournalModule extends BaseJournalModule
{

    protected $_serverHost = '';
    protected $_requestMethod = '';
    protected $_requestUri = '';

    protected $_ip = '';
    protected $_ua = '';
    protected $keyMap=[
        'HTTP_X_FORWARDED_FOR' => 'x-forwarded-for',
        'HTTP_ALI_CDN_REAL_IP' => 'ali-cdn-real-ip',
        'REMOTE_ADDR' => 'remote_addr',
        'HTTP_USER_AGENT' => 'user-agent',
        'REQUEST_METHOD' => 'request_method',
        'REQUEST_URI' => 'request_uri',
        'HTTP_HOST' => 'host',
        'HTTP_API_DOMAIN' => 'api-domain',
    ];

    public function __construct()
    {
        parent::__construct();
        $this->_ip = $this->getIp();
        $this->setUa();
        $this->_requestMethod =  $this->getHeader('REQUEST_METHOD');
        $this->_requestUri =  $this->getHeader('REQUEST_URI');
        $domain = $this->getHeader('HTTP_API_DOMAIN');
        if (!$domain) $domain = $this->getHeader('HTTP_HOST');
        $this->_serverHost =  $domain;
    }

    public function setUa($ua=null)
    {
        if (!$ua ) $ua = $this->getHeader('HTTP_USER_AGENT');
        $this->_ua = empty($ua)?'-':$ua;
    }
    /**
     * @param $key
     * @return mixed|string
     */
    protected function getHeader($key){
        if ($this->getProject() === journalConst::PROJECT_NAME_EASySWOOLE) {
            $key =  isset($this->keyMap[$key])?$this->keyMap[$key] : $key;
            if (class_exists('\App\Common\Helper\CoDiHelper')) {
                $request = \App\Common\Helper\CoDiHelper::get('request');
            }else{
                $request=null;
            }
            if($request){
                if (in_array($key,['request_method','request_uri','remote_addr'])){
                    $server = $request->getServerParams();
                    $ret = isset($server[$key]) ? $server[$key] : '';
                }else{
                    $header = $request->getHeader($key);
                    $ret = array_pop($header);
                }
                return $ret;
            }
            return '-';
        }else{
            return  isset($_SERVER[$key])?$_SERVER[$key]:'';
        }
    }

    public function getSessionId(){
        if ($this->_sessionId) {
            return $this->_sessionId;
        }
        $sessId = $this->getCookie()->get(journalConst::COOKIE_SESSION_ID_KEY,'');
        if (empty($sessId)) {
            $sessId = 'sl' . uniqid() . mt_rand(100000, 900000);
            $this->getCookie()->set(journalConst::COOKIE_SESSION_ID_KEY,$sessId,0,'/', $this->_serverHost);
        }
        $this->_sessionId = $sessId;
        return $sessId;
    }

    protected $_cookieId;

    public function getCookieId(){
        if ($this->_cookieId) {
            return $this->_cookieId;
        }
        $cookieId = $this->getCookie()->get(journalConst::COOKIE_COOKIE_ID_KEY,'');
        if (empty($cookieId)) {
            $cookieId = 'ci' . uniqid() . mt_rand(100000, 900000);
            $this->getCookie()->set(journalConst::COOKIE_COOKIE_ID_KEY,$cookieId,time() + 86400*365,'/',$this->_serverHost);
        }
        $this->_cookieId = $cookieId;
        return $cookieId;
    }
    /**
     *获取客户端的IP地址
     * @return string
     */
    protected function getIp(){
        $ip =  $this->getHeader('HTTP_ALI_CDN_REAL_IP');
        if ($ip) {
            return $ip;
        }
        $ip =  $this->getHeader('HTTP_X_FORWARDED_FOR');
        if ($ip) {
            str_replace('unknown','',$ip);
            $ip = explode(',',$ip);
            $index = array_search('',$ip);
            if ($index !== false) {
                unset($ip[$index]);
            }
            if ($ip && count($ip) >0) {
                return end($ip);
            }
        }
        $ip =  $this->getHeader('REMOTE_ADDR');
        if ($ip) {
            return $ip;
        }
        return '-';
    }
    
    protected $cookieInitJournalModule=false;
    public function getAttributeAsArr(){
        $arr = (array)$this;
        $ret= [];
        foreach ($arr as $key =>$value) {
            ## debug 属性名称必须为字符串
            if (!is_string($key) ) continue;
            if (strpos($key,'JournalModule')!==false) {
                continue;
            }
            
            if (mb_substr($key,1,1,'utf-8')== '*') {
                $key = mb_substr($key,3);
            }
            if($key == 'keyMap') continue;
            if (is_null($value)) {
                $value = 'value is null';
            }
            $ret[$key] = $value;
        }
        $ret['_sessionId'] = $this->getSessionId();
        $ret['_cookieId'] = $this->getCookieId();
        $ret['_last_requestId'] = $this->getCookie()->get(journalConst::COOKIE_LAST_REQUEST_KEY,'');
        $ret['_last_logName'] = $this->getCookie()->get(journalConst::COOKIE_LAST_LOG_NAME,'');
        if(!$this->cookieInitJournalModule){
            $this->getCookie()->set(journalConst::COOKIE_LAST_REQUEST_KEY,$this->_requestId,0,'/',$this->_serverHost);
            $this->getCookie()->set(journalConst::COOKIE_LAST_LOG_NAME,$this->getLogName(),0,'/',$this->_serverHost);
            $this->cookieInitJournalModule=true;
        }
        return $ret;
    }
    
  
    
    /**
     * @return string
     */
    public function getLogName(): string
    {
        return $this->logName;
    }

}