<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 2:43 PM
 */

namespace kmkj\JournalModule\core\request;


use kmkj\JournalModule\interfaces\WebUser;

class WebUserJournalModule extends BaseRequestJournalModule implements WebUser
{
    protected $logName='webuser';
    protected $needRecordResponse = false;

    public function __construct()
    {
        parent::__construct();
    }

    public function getDefaultLogName()
    {
        return $this->logName;
    }
    /**
     * @var int  微信客户ID
     */
    protected $_wechatId =0;
    /**
     * @var int  uid
     */
    protected $_uid =0;

    /**
     * @var string 请求的token
     */
    protected $_token='';
    /**
     * @var string post请求的包体
     */
    protected $_body='';
    /**
     * @var string 用户来源的域名
     */
    protected $_fromDomain='';
    /**
     * @var int 应用ID
     */
    protected $_appId=0;

    /**
     * @var string app的中文名字
     */
    protected $app_chinese;

    public function setAppChinese($appChinese)
    {
        $this->app_chinese = $appChinese;
        return $this;
    }
    public function setWeChatId($weChatId)
    {
        $this->_wechatId = (int)$weChatId;
        return $this;
    }

    public function setUid($uid)
    {
        $this->_uid = (int)$uid;
        return $this;
    }

    public function setToken($token)
    {
        $this->_token = $token;
        return $this;
    }


    public function setBody($body)
    {
        if (!is_array($body)) {
            $body = http_build_query($body);
        }
        if (strlen($body) > 1024){
            $this->_body ="内容过长";
            return $this;
        }
        $this->_body = $body;
        return $this;
    }

    public function setFromDomain($domain)
    {
        $this->_fromDomain = $domain;
        return $this;
    }

    public function setAppId($appId)
    {
        $this->_appId = (int)$appId;
        return $this;
    }

    /**
     * 设置是否需要记录响应结果
     * @param $bool
     * @return $this
     * @User: 阿豹
     * @Date: 2020/4/18
     */
    public function needRecordResponse($bool)
    {
        $this->needRecordResponse = $bool;
        return $this;
    }

    /**
     * 获取是否需要记录响应结果状态
     * @return bool
     */
    public function getNeedRecordResponse(){
        return $this->needRecordResponse;
    }

}