<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/2/24
 * Time: 17:05
 */
namespace kmkj\log\ali;
use kmkj\common\Config;

/**
 * 阿里云日志基础类
 * Class LogClient
 * @author xiaozhou
 * @link https://help.aliyun.com/document_detail/29074.html
 * @package kmkj\log\ali
 */

class LogClient {

    protected $client;

    protected $project;
    //        // 如果是debug的日志那么久写入到 logdev的项目里面去
    public $debugProject='logDev';
    protected $kmkjProject;

    public $logStore;

    protected $isConfigOk = true;

    public function init($conf = [])
    {
        if (empty($conf)|| !is_array($conf)) {
            $conf = $this->getConfig($conf);
        }
        try{
            if (empty($conf['endpoint']) || empty($conf['accessId']) || empty($conf['accessKey'])){
                $this->isConfigOk =false;
                return;
            }
            $this->client = new \Aliyun_Log_Client($conf['endpoint'],$conf['accessId'],$conf['accessKey']);
            $this->project = $conf['project'];
            $this->logStore = $conf['logStore'];

            //列出当前project下的所有日志库名称
            /*
            $req = new Aliyun_Log_Models_ListLogstoresRequest($conf['project']);
            $res1 = $client->listLogstores($req);
            */
        }catch (\Exception $e){
            $this->errorLog($e->getMessage());
        }
    }

    /**
     * @return \Aliyun_Log_Client
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * 获取阿里去云配置参数
     * @param string $conf
     * @return array
     */
    public function getConfig( $conf = 'log')
    {
        if (empty($conf)) {
            $conf = 'log';
        }
        if (!is_string($conf)) {
            return (array)$conf;
        }
        $conf = new Config($conf,'ali');
        $ret['endpoint'] = $conf->getConfig('endpoint');
        $ret['accessId'] = $conf->getConfig('accessId');
        $ret['accessKey'] = $conf->getConfig('accessKey');
        $ret['project'] = $conf->getConfig('project');
        $ret['logStore'] = $conf->getConfig('logStore');
        return $ret;
    }

    /**
     * 获取框架的runtime目录
     * 获取RunTime目录
     * @return string
     */
    public function getRunTimePath()
    {
        $config =  new Config('log','ali');
        $runTimePath = './';
        switch ($config->getProject()) {
            case 'easySwoole':
                if(defined('EASYSWOOLE_ROOT'))
                    $runTimePath= EASYSWOOLE_ROOT.'/Log';
                break;
            case 'tp51':
                $runTimePath = \think\facade\App::getRuntimePath()."/";
                break;
            case 'tp32':
                $runTimePath= APP_PATH.'Runtime/';
                break;
        }
        return $runTimePath;
    }
    /**
     * @param \Exception $exception
     * @User: 阿豹
     * @Date: 2020/4/17
     */
    protected function setError($exception){
        $path = $this->getRunTimePath();
        $str = date("Y-m-d H:i:s") . "\t";
        $str .= $exception->getMessage() . "\t";
        $str .= $exception->getFile() . '['.$exception->getLine().']'."\t";
        $str .= json_encode($exception->getTrace());
        file_put_contents($path."/logErr.log",$str,true);
    }

    /**
     * 写错误日志
     * @param $msg
     * @param string $fileName
     */
    public function errorLog($msg,$fileName='LogError.log')
    {
        $runTimePath= $this->getRunTimePath();
        $aa = debug_backtrace(10);
        error_log(date("Y-m-d H:i:s").$msg."\t".json_encode($aa,JSON_UNESCAPED_UNICODE)."\n",3,$runTimePath.$fileName);
    }
}