<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 10:12 AM
 */

namespace kmkj\JournalModule\core;

use kmkj\common\Cookie;
use kmkj\common\LogObjectAsArray;
use kmkj\JournalModule\header\journalConst;
use kmkj\log\handler\LogHandler;

abstract class BaseJournalModule implements \ArrayAccess,\Iterator,\Countable
{
    use LogObjectAsArray;
    /**
     * 提交数据到阿里云的操作类
     * @var LogHandler
     */
    protected  $logHandler;
    public $msg ='默认消息';
    private  $traceIndex=2;
    protected $logConfig=journalConst::CONFIG_NAME_DEFAULT;
    protected $debugProject = journalConst::CONFIG_DEBUG_NAME_DEFAULT;

    /**
     * @var Cookie
     */
    protected static $cookie;

    /**
     * @return Cookie
     * @User: 阿豹
     * @Date: 2020/4/18
     */
    protected function getCookie(){
        if (empty(self::$cookie)) {
            self::$cookie =  new Cookie();
        }
        return self::$cookie;
    }

    protected $_sessionId='';



    public function getDebugProject(){
        return $this->debugProject;
    }

    public function setDebugProject($name)
    {
        $this->debugProject = $name;
        return $this;
    }
    public function getLogConfig(){
        return $this->logConfig;
    }

    public function setLogConfig($config)
    {
        $this->logConfig =$config;
        return $this;
    }
    /**
     * @var string 所属项目
     */
    protected static $_project;

    protected $_hasSuccess=1;
    /**
     * @var string 创建时间 时间戳
     */
    protected $_creteTime;
    /**
     * @var string 创建的年月日 YYY-MM-DD
     */
    protected $_creteDate;
    /**
     * @var string 服务器的主机名称
     */
    protected $_hostName;

    /**
     * 请求ID
     * @var string
     */
    protected $_requestId = '';

    protected $data=[];

    public function __construct()
    {
        if (!self::$_project){
            $this->setProject();
        }

        $this->_creteDate = date("Y-m-d");
        $this->_creteTime = time();
        $this->_hostName = gethostname();
        $this->_requestId =  uniqid('',true).mt_rand(1000000,9000000);
    }

    public function getProject(){
        return self::$_project;
    }

    /**
     * 设置所属项目
     * @return $this
     */
    public function setProject()
    {
        $pr='debug';
        if (class_exists('\EasySwoole\EasySwoole\Config')){
            $pr = journalConst::PROJECT_NAME_EASySWOOLE;
        } elseif (defined('THINK_VERSION') && THINK_VERSION === '3.2.3'){
            $pr = journalConst::PROJECT_NAME_TP32;
        }else {
            $pr = journalConst::PROJECT_NAME_TP51;
        }
        self::$_project = $pr;
       return $this;
    }

    public function setIsError(){
        $this->_hasSuccess = 0;
        return $this;
    }


    public function getAttributeAsArr(){
        $arr = (array)$this;
        $ret= [];
        foreach ($arr as $key =>$value) {
            if (!is_string($key)) {
                continue;
            }
            if (strpos($key,'JournalModule')!==false) {
                continue;
            }
            if (mb_substr($key,1,1,'utf-8')== '*') {
                $key = mb_substr($key,3);
            }
            if($key == 'keyMap') continue;
            if (is_null($value)) {
                $value = 'value is null';
            }
            $ret[$key] = $value;
        }
        return $ret;
    }

    /**
     * 获取日志上传对象
     * @return LogHandler
     */
    public function getLogHandler()
    {
        if (empty($this->logHandler)) {
            $this->logHandler = new LogHandler($this->getLogConfig());
        }
        return $this->logHandler;
    }

    /**
     * 将写入的数据和搜集到的数据合并起来
     * @param $data
     * @return array
     */
    protected function mergeData($data){
        if (!is_array($data)) {
            $data = ['data' => (string) $data];
        }else{
            $data = ['data' =>$data];
        }
        $data['data'] = array_merge($this->getData(), $data['data']);
        $data = array_merge($this->getAttributeAsArr(), $data);
        return $data;
    }
    
    private $_topic='';
    
    /**
     * 用来定义一个大范围的模块
     * @param string $topic
     * @return $this
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/11/20 |设置一个topic|
     * @Date: 2020/11/20
     */
    public function setTopic(string $topic)
    {
        $this->_topic =$topic;
        return$this;
    }
    
    /**
     * 获取日志的topic 用来定义一个大范围的模块
     * @return string
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/11/20 |获取日志的topic默认为项目名称|
     * @Date: 2020/11/20
     */
    public function getTopic(){
        if ($this->_topic) {
            return $this->_topic;
        }
        return  $this->getProject();
    }
    
    protected  $forceWrite='';
    
    /**
     * 强制指定日志写到哪里去
     * @param string $level  info,debug,error,alert
     * @return $this
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/11/20 |强制指定日志写到哪里去|
     * @Date: 2020/11/20
     */
    public function forceWrite( string $level){
        $this->forceWrite=$level;
        return$this;
    }
    
    /**
     * 记录一条info级别的日志
     * @param $msg
     * @param array $data
     * @param string $logName
     */
    public function info($msg,$data=[],$logName=''){
        $data = $this->mergeData($data);
        if ($msg) unset($data['msg']);
        $level = $level=$this->forceWrite ? $level=$this->forceWrite:journalConst::INFO;
        return $this->getLogHandler()->addAliLog($msg,$data,$level,$logName,$this->getTopic());
    }

    /**
     * 打印一条 alert级别的日志
     * @param $msg
     * @param $data
     * @param $logName
     * @User: 阿豹
     * @Date: 2020/4/17
     */
    public function alert($msg,$data,$logName=''){
        if (!$logName) {
            $logName =$this->getDefaultLogName();
        }
        $data = $this->mergeData($data);
        if ($msg) unset($data['msg']);
        $level = $level=$this->forceWrite ? $level=$this->forceWrite:journalConst::ALERT;
    
        return $this->getLogHandler()->addAliLog($msg,$data,$level,$logName,$this->getTopic());
    }
    /**
     * 记录一条debug的错误日志
     * @param $msg
     * @param array $data
     * @param string $logName
     */
    public function debug($msg,$data=[],$logName='')
    {
        if (!$logName) {
            $logName =$this->getDefaultLogName();
        }
        $arr = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,2);
        $data = $this->mergeData($data);
        if ($msg) unset($data['msg']);
        //  如果是debug的日志那么久写入到 logdev的项目里面去
        $this->getLogHandler()->debugProject = $this->getDebugProject();
        $arr = isset($arr[$this->traceIndex])?$arr[$this->traceIndex]:[];
        $data['_FILE_'] = isset($arr['file'])?$arr['file']:'' ;
        $data['_LINE_'] =  isset($arr['line'])?$arr['line']:'' ;
        $data['_FUNCTION_'] =  isset($arr['function'])?$arr['function']:'' ;
        
        $level = $level=$this->forceWrite ? $level=$this->forceWrite:journalConst::DEBUG;
        return $this->getLogHandler()->addAliLog($msg,$data,$level,$logName,$this->getTopic());
    }

    /**
     * 记录一条错误日志
     * @param $msg
     * @param array $data
     * @param string $logName
     */
    public function error($msg,$data=[],$logName=''){
        if (!$logName) {
            $logName =$this->getDefaultLogName();
        }
        $arr = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,$this->traceIndex);
        $data = $this->mergeData($data);
        if ($msg) unset($data['msg']);
        $arr = $arr[$this->traceIndex];
        $data['_FILE_'] = isset($arr['file'])?$arr['file']:'' ;
        $data['_LINE_'] =  isset($arr['line'])?$arr['line']:'' ;
        $data['_FUNCTION_'] =  isset($arr['function'])?$arr['function']:'' ;
        
        $level = $level=$this->forceWrite ? $level=$this->forceWrite:journalConst::ERROR;
    
        $data = $this->mergeData($data);
        return $this->getLogHandler()->addAliLog($msg,$data,$level,$logName,$this->getTopic());

    }

    /**
     * 将设置在 data的属性提交到阿里云
     * 刷新日志出去
     * @param $msg
     * @param $level
     * @param string $logName
     * @return string
     */
    public function flushLog($msg='',$level=200,$logName=''){
        $data = $this->getData();
        if (empty($data)){
            return '';
        }
        if (!$logName) {
            $logName =$this->getDefaultLogName();
        }
        $this->traceIndex++;
        $method = [100 => 'debug', 200 => 'info', 400 => 'error',250=>'alert'];
        $ret= $this->{$method[$level]}($msg,$data,$logName);
        $this->setData([]);
    }
    
    
    /**
     * 设置需要保存到阿里云的数据
     * @param $data
     * @return $this
     * @deprecated
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/11/20 |变更内容|
     * @Date: 2020/11/20
     */
    public function setData($data){
        $this->data =  $data;
        return $this;
    }
    
    /**
     * 追加一些数据到日志里面去
     * @link http://doc.kuaimenkeji.com/web/#/12?page_id=2435
     * $log['list'] =["abcd"]
     *  错误的写法---$log['list'][]="aaa"
     * $log->dataPush('list','aa')
     * @param $key
     * @param $value
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/2 |追加一些数据到日志里面去|
     * @Date: 2020/12/2
     */
    public function dataArrayPush($key,$value){
        if (!isset($this->data[$key])) {
            $this->data[$key]=[];
        }
        $this->data[$key][] = $value;
    }
    
    /**
     * 合并数组操作
     * 代替系统的ArrayMerge
     * @link http://doc.kuaimenkeji.com/web/#/12?page_id=2435
     * @param mixed ...$arr
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/2 |合并数组操作|
     * @Date: 2020/12/2
     */
    public function dataArrayMerge(...$arr)
    {
        array_unshift($arr,$this->data);
        $this->data =call_user_func_array('array_merge',$arr);
    }
    
    /**
     * @link http://doc.kuaimenkeji.com/web/#/12?page_id=2435
     * @param $key
     * $log['list'] =["a","b"]
     *  错误的写法 array_pop($log['list']);
     * $log->dataArrayPop('list')
     * @return |null
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/2 |变更内容|
     * @Date: 2020/12/2
     */
    public function dataArrayPop($key){
        if (!isset($this->data[$key])) {
            return null;
        }
        array_pop($this->data[$key]);
    }
    
    /**
     * 获取data属性
     * @return array
     * @User: 阿豹
     * @Date: 2020/4/29
     */
    public function getData(){
        $data = $this->data;
        if (!is_array($this->data)) {
            $data = (array)$data;
        }
        return $data;
    }

    protected $logName = "";
    /**
     * @param string $logName
     */
    public function setDefaultLogName(string $logName)
    {
        $this->logName = $logName;
        return $this;
    }

    public function getDefaultLogName()
    {
        return $this->logName;
    }
}