<?php


namespace kmkj\JournalModule\core\Command;


/**
 * mq 消费者日志查询
 * Class MqCommandJournalModel
 * @User 阿豹
 * @package kmkj\JournalModule\core\Command
 */
class MqCommandJournalModel extends BaseCommandJournalModel
{
    protected $_uid;
    // 应用ID
    protected $_appId;
    //保存Topic
    protected $_msgType;
    // 保存 tag
    protected $_event;
    // 保存
    protected $_content;
    // 消费延时
    protected $_consumption_delay;

    /**
     * 设置消费延时
     * @param float $consumption_delay
     */
    public function setConsumptionDelay($consumption_delay)
    {
        $this->_consumption_delay = $consumption_delay;
    }

    /**
     * 设置消费次数
     * @param int $consumption_times
     */
    public function setConsumptionTimes($consumption_times)
    {
        $this->_consumption_times = $consumption_times;
    }

    /**
     * 设置程序的运行时间
     * @param int $runtime
     */
    public function setRuntime(int $runtime)
    {
        $this->_runtime = $runtime;
    }
    // 消费次数
    protected $_consumption_times;
    // 运行时间
    protected $_runtime=-1;
    // 设置UID
    public function setUid($uid){
        $this->_uid=$uid;
        return $this;
    }

    /**
     * @param $int
     * @return $this
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2021/09/07 18:29 |设置是否操作成功|
     */
    public function setIsSuccess($int){
        $this->_hasSuccess=$int;
        return $this;
    }

    /**
     * 设置msg. tag
     * @param $str
     * @return $this
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2021/09/07 18:29 |变更内容|
     */
    public function setMsgTag($str){
        $this->_event=$str;
        return $this;
    }

    /**
     * @param $msgType 设置topic
     * @return $this
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2021/09/07 18:30 |变更内容|
     */
    public function setMsgTopic($msgType){
        $this->_msgType=$msgType;
        return $this;
    }

    /**
     * 设置应用ID
     * @param $appId
     * @return $this
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2021/09/07 18:31 |变更内容|
     */
    public function setAppId($appId){
        $this->_appId=$appId;
        return $this;
    }


    public function setContent($content){
        $this->_content=$content;
        return $this;
    }

}