<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 2:43 PM
 */

namespace kmkj\JournalModule\core\request;


use kmkj\JournalModule\interfaces\WebUser;

class WebsiteJournalModule extends BaseRequestJournalModule
{
    protected $logName='官网';
    protected $needRecordResponse = false;
    
    /**
     * 重用日志索引
     * 设置爬虫类型 百度/搜狗等
     * @param string $event
     */
    public function setEvent(string $event)
    {
        $this->_event = $event;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->_content;
    }
    
    /**
     * 重用日志索引
     * 设置IP反查出来的内容
     * @param string $content
     */
    public function setContent(string $content)
    {
        $this->_content = $content;
        return $this;
    }
    
    
    /**
     * 前端用户获取到初始来源的地址
     * @var string
     */
    protected $_firset_domain ='';
    /**
     * @var string app的中文名字
     */
    protected $app_chinese;
    

    public function setBody($body)
    {
        if (!is_array($body)) {
            $body = http_build_query($body);
        }
        if (strlen($body) > 1024){
            $this->_body ="内容过长";
            return $this;
        }
        $this->_body = $body;
        return $this;
    }

  
    /**
     * 设置是否需要记录响应结果
     * @param $bool
     * @return $this
     * @User: 阿豹
     * @Date: 2020/4/18
     */
    public function needRecordResponse($bool)
    {
        $this->needRecordResponse = $bool;
        return $this;
    }

    /**
     * 获取是否需要记录响应结果状态
     * @return bool
     */
    public function getNeedRecordResponse(){
        return $this->needRecordResponse;
    }

}