<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/14
 * Time: 10:11 AM
 */

namespace kmkj\common;


trait LogObjectAsArray
{
    
    
    public function count()
    {
        return count($this->data);
    }
    /**
     * 检查是否存在某个keys
     * @param $offset
     * @return bool
     */
    public function offsetExists($offset)
    {
        if (isset($this->{$offset})){
            return true;
        }else{
            return isset($this->data[$offset]);
        }
    }

    /**
     * 获取某个属性Z
     * @param $offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        if (isset($this->{$offset})){
            return $this->{$offset};
        }else{
            return $this->data[$offset]??null;
        }
    }

    public function offsetSet($offset, $value)
    {
        if (isset($this->{$offset})){
            $this->{$offset} = $value;
        }else{
            $this->data["{$offset}"] = $value;
        }
    }

    public function offsetUnset($offset)
    {
        if (isset($this->{$offset})){
            $this->{$offset} = null;
        }else{
            unset($this->data["{$offset}"]);
        }
    }
    
    /**
     * 返回当前元素
     * @return mixed
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/1 |返回当前元素|
     * @Date: 2020/12/1
     */
    public function current ()
    {
        return current($this->data);
    }
    
    /**
     * 向前移动到下一个元素
     * @return mixed
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/1 |向前移动到下一个元素|
     * @Date: 2020/12/1
     */
    public function next()
    {
        $ret= next($this->data);
        $this->currentKey= key($this->data);
        return $ret;
    }
    
    /**
     * 返回到迭代器的第一个元素
     * @return bool
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/1 |返回到迭代器的第一个元素|
     * @Date: 2020/12/1
     */
    public function rewind()
    {
        $ret= reset($this->data);
        $this->currentKey= key($this->data);
        return $ret;
    }
    
    /**检查当前位置是否有效
     * @return bool
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/1 |检查当前位置是否有效|
     * @Date: 2020/12/1
     */
    public function valid ()
    {
        return $this->current() !== false;
    }
    
    /**
     * 返回当前元素的键
     * @return int|string|null
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 |2020/12/1 |返回当前元素的键|
     * @Date: 2020/12/1
     */
    public function key ()
    {
        return key($this->data);
    }
    
    private $currentKey;
    private function getKey(){
        if ($this->currentKey) {
            return $this->currentKey;
        }
        return $this->currentKey = key($this->data);
    }
}