<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2020/2/24
 * Time: 17:05
 */
namespace kmkj\log\ali;

/**
 * 阿里云日志基础类
 * Class LogClient
 * @author xiaozhou
 * @link https://help.aliyun.com/document_detail/29074.html
 * @package kmkj\log\ali
 */

class LogClient {

    protected $client;

    protected $project;

    public $logStore;

    public function init($conf = [])
    {
        if (empty($conf)) {
            $conf = $this->getConfig($conf);
        }
        try{
            $this->client = new \Aliyun_Log_Client($conf['endpoint'],$conf['accessId'],$conf['accessKey']);
            $this->project = $conf['project'];
            $this->logStore = $conf['logStore'];
            $this->kmkjProject = $conf['kmkjProject'];

            //列出当前project下的所有日志库名称
            /*
            $req = new Aliyun_Log_Models_ListLogstoresRequest($conf['project']);
            $res1 = $client->listLogstores($req);
            */
        }catch (\Exception $e){
            $this->errorLog($e->getMessage());
        }
    }

    /**
     * @return mixed
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * 获取阿里去云配置参数
     * @param string $conf
     * @return array
     */
    public function getConfig( $conf = [])
    {
        $ret=[];
        if(function_exists('M') &&function_exists('A') && function_exists('G') ){
            // tp3.2 的配置加载
            $ret['endpoint'] = C('LOG_ENDPOINT');
            $ret['accessId'] = C('LOG_ACCESSID');
            $ret['accessKey'] = C('LOG_ACCESSKEY');
            $ret['kmkjProject'] = C('LOG_KMKJPROJECT');
            $ret['project'] = C('LOG_PROJECT');
            $ret['logstore'] = C('LOG_LOGSTORE');
        } elseif (class_exists('think\app')){
            // tp5 的配置加载
            $ret['endpoint'] = env('log.endpoint','');
            $ret['accessId'] = env('log.accessId','');
            $ret['accessKey'] = env('log.secretKey','');
            $ret['kmkjProject'] = env('log.kmkjProject','');
            $ret['project'] = env('log.project','');
            $ret['logStore'] = env('log.logStore','');
        } elseif (class_exists('\EasySwoole\EasySwoole\Config')){
            //EasySwoole框架加载文件
            $instance = \EasySwoole\EasySwoole\Config::getInstance();
            $ret['endpoint'] = $instance->getConf('ali.log.endpoint','');
            $ret['accessId'] = $instance->getConf('ali.log.accessId','');
            $ret['accessKey'] = $instance->getConf('ali.log.secretKey','');
            $ret['kmkjProject'] = $instance->getConf('ali.log.kmkjProject','');
            $ret['project'] = $instance->getConf('ali.log.project','');
            $ret['logStore'] = $instance->getConf('ali.log.logStore','');
        }else{
            //默认加载配置文件
            $ret = require dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'conf' . DIRECTORY_SEPARATOR . 'config.php';
        }
        return $ret;
    }

    /**
     * 获取RunTime目录
     * @return string
     */
    protected function getRunTimePath()
    {
        $runTimePath = './';
        if(function_exists('M') &&function_exists('A') && function_exists('G')){
            $runTimePath= APP_PATH.'Runtime/';
        }elseif (class_exists('think\app')){
            $runTimePath = \think\facade\App::getRuntimePath()."/";
        }
        return $runTimePath;
    }

    /**
     * 写错误日志
     * @param $msg
     * @param string $fileName
     */
    public function errorLog($msg,$fileName='LogError.log')
    {
        $runTimePath= $this->getRunTimePath();
        $aa = debug_backtrace(10);
        error_log(date("Y-m-d H:i:s").$msg."\t".json_encode($aa,JSON_UNESCAPED_UNICODE)."\n",3,$runTimePath.$fileName);
    }
}