<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2019/11/13
 * Time: 4:11 PM
 */

namespace kmkj\mq\ali;

use MQ\MQClient;

class aliClient
{



    protected $mqId=null;

    protected $groupId;

    /**
     * @var MQClient
     */
    protected $client;

    public function setClient($conf=''){

        if (!is_array($conf)) {
            $conf = $this->getConfig($conf);
        }
        $this->client = new MQClient($conf['domain'],$conf['accessId'],$conf['accessKey']);
        $this->mqId = $conf['mq_id'];
        $this->groupId = isset($conf['groupId'])?$conf['groupId']:'GID_content';
    }

    /**
     * @return MQClient
     */
    public function getClient(){
        return $this->client;
    }

    /**
     * @param string $conf
     * @return array
     */
    public function getConfig($conf=''){
        $ret=[];
        if(function_exists('M') &&function_exists('A') && function_exists('G') ){
            $ret['domain'] = C('mq_domain','');
            $ret['accessId'] = C('mq_accessId','');
            $ret['accessKey'] = C('mq_secretKey','');
            $ret['mq_id'] = C('mq_id','');
        }elseif (class_exists('think\app')){
            // tp5 的配置加载
            $ret['domain'] = env('mq.domain','');
            $ret['accessId'] = env('mq.accessId','');
            $ret['accessKey'] = env('mq.secretKey','');
            $ret['mq_id'] = env('mq.id','');

        }else{
            $ret = require './config.php';
        }

        return $ret;
    }

    protected function getRunTimePath(){
        $runTimePath = './';
        if(function_exists('M') &&function_exists('A') && function_exists('G')){
            $runTimePath= APP_PATH.'Runtime/';
        }elseif (class_exists('think\app')){
            $runTimePath = \think\facade\App::getRuntimePath()."/";

        }
        return $runTimePath;
    }
    public function errorLog($msg,$fileName='mqError.log')
    {
        $runTimePath= $this->getRunTimePath();
        $aa = debug_backtrace(10);
        error_log(date("Y-m-d H:i:s").$msg."\t".json_encode($aa,JSON_UNESCAPED_UNICODE)."\n",3,$runTimePath.$fileName);
    }
}