<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2019/11/8
 * Time: 5:00 PM
 */

namespace kmkj\mq\producer;
use GuzzleHttp\Exception\GuzzleException;
use kmkj\mq\ali\aliClient;
use kmkj\mq\ex\MqException;
use MQ\MQClient;

/**
 * Class product
 * @package kmkj\mq
 */
abstract class  product extends aliClient
{

    /**
     * @var static
     */
    protected static $ind;


    protected $currTopic;
    protected $method;
    protected $fnData;
    public static function getInd()
    {
        if (empty(static::$ind)) {
            static::$ind =  new static();
        }
        return  static::$ind;
    }
    /*protected function __construct()
    {
    }
    protected function __clone()
    {
    }*/

    public function __construct()
    {
        $this->setClient();
    }



    /**
     * @param $topic
     * @return \MQ\MQProducer
     */
    public function getProduct($topic){
        $this->currTopic = $topic;
        return $this->client->getProducer($this->mqId,$topic);
    }



    public function pareData($msgData){
        $ret = [ 'type' =>'string','data'=>$msgData];
        if (is_array($msgData)) {
            $ret['type'] = "array";
            $ret['data'] = json_encode($msgData,JSON_UNESCAPED_UNICODE);
        }
        return json_encode($ret,JSON_UNESCAPED_UNICODE);
    }

    /**
     * @param $name
     * @param array $arguments
     * @return mixed
     */
    public static function  __callStatic(  $name ,  $arguments){
        $ind = new static();
        if ( method_exists($ind,'_'.$name)) {
            return call_user_func_array([$ind,'_'.$name],$arguments);
        }
    }

    /**
     * @param \Exception $exception
     * @throws
     */
    public function setErr( $exception){
        if (strpos($exception->getMessage(),'valid resource owner failed') !== false) {
            throw new MqException($exception->getMessage(),$exception->getCode());
        }
        if ($exception->getMessage()) {
           $this->errorLog($exception->getMessage());
        }
    }


    /**
     * @param $fn callable
     * @param $args array 调用参数
     * @param $tryNum int 重试次数
     * @return mixed
     * @throws
     */
    public function tryPush($fn,$args,$tryNum=3){
        $num =0;
        $err = null;
        while ($num < $tryNum) {
            try {
                    $num++;
                    $data = call_user_func_array($fn,$args);
                    return $data;
            } catch (MqException $exception) {
                $err=$exception;
               break;
            }catch (\Error $error) {
                $this->setErr($error);
            }
            catch (\Exception $exception) {
                $this->setErr($exception);
            }
            catch (\Throwable $exception) {
                $this->setErr($exception);
            }catch (GuzzleException $exception) {
                $this->setErr($exception);
            }
        }
        // 异常不需要记录日志
        if ($err) {
            throw $err;
        }
        $this->failTask();
    }


    public function failTask(){

        $arr =[];
        $arr['callback'] =$this->method;
        $arr['arg'] =$this->fnData;
        $str = serialize($arr);
        $runTime = $this->getRunTimePath();
        error_log(date("Y/m/d H:i:s")."\t".$str,3,$runTime.'/mq_fail_task.log');
    }

}