<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 11:43 AM
 */

namespace kmkj\oss\core;


use GuzzleHttp\RequestOptions;
use http\Client;
use kmkj\oss\client\MyOssClient;
use kmkj\oss\ex\OssUploadException;
use kmkj\oss\header\OssConst;
use OSS\OssClient;


/**
 * 阿里云的上传对象
 * Class Upload
 * @package kmkj\oss\core
 */
class Upload extends MyOssClient
{

    private $options =[];

    /**
     * 调用阿里云云函数的域名
     * @var string
     */
    protected $fcDomain = 'http://oss-alifn.kuaimenkeji.com';
    protected $fcInternalDomain = 'http://oss-alifn.kuaimenkeji.com';


    /**
     * 调用阿里云云函数的域名
     * @var string
     */
    protected $fcDomainHk = 'http://oss-hk-alifn.kuaimenkeji.com';

    /**
     * 保存的临时文件未知
     * @var string
     */
    protected $tempDir='';
    public function setTemDIr($tempDir){
        if (!is_dir($tempDir)) {
            throw new \Exception("{$tempDir} 不是一个目录");
        }
        $this->tempDir=$tempDir;
        return $this;
    }
    /**
     * 设置文件为私有
     * @return $this
     */
    public function setFilePrivate()
    {
        $this->setOption(OssClient::OSS_OBJECT_ACL,OssClient::OSS_ACL_TYPE_PRIVATE);
        return $this;
    }

    /**
     * 设置文件为公共读,权限写
     * @return $this
     */
    public function setFileOnlyRead(){
        $this->setOption(OssClient::OSS_OBJECT_ACL, OssClient::OSS_ACL_TYPE_PUBLIC_READ);
        return $this;
    }

    /**
     * 删除所有的选项值
     */
    public function clearOptions(){
        $this->options =[];
    }

    /**
     * 设置文件的过期时间
     * @param $value
     * @return $this
     */
    public function setExpire($value){
        $tag = OssConst::FILE_EXPIRE_TAG_NAME."=".urlencode($value);
        $this->setOption('x-oss-tagging',$tag);
        $this->setOption('expire_time',1);
        return $this;
    }

    /**
     * 设置一个选项
     * @param $key
     * @param $value
     * @return $this
     */
    public function setOption($key,$value){
        $this->options[OssClient::OSS_HEADERS][$key] = $value;
        return $this;
    }

    /**
     * 是否有设置某个options
     * @param $key
     * @return bool
     */
    public function hasOption($key){
        return isset( $this->options[OssClient::OSS_HEADERS][$key]);
    }

    /**
     * 在上传之前处理文件的路径
     * @param $bukFileName
     * @return string
     */
    protected function filterFileName($bukFileName)
    {
        if ($this->hasOption('expire_time')) {
            $bukFileName = OssConst::FILE_EXPIRE__PREFIX.'/'.$bukFileName;
        }
        return $bukFileName;
    }
    /**
     * 上传一个字符串到oss上上面去
     * @param $bukFileName string 上传之后访问的文件地址
     * @param $content string 需要上传的字符串
     * @return BucketFile
     * @throws OssUploadException
     * @throws \OSS\Core\OssException
     */
    public function putObject($content,$bukFileName)
    {
        $bukFileName = $this->filterFileName($bukFileName);
        $rep = $this->getClient()
            ->putObject($this->getBucket(), $bukFileName,$content, $this->options);
        if (!empty($rep['info']) && $rep['info']['http_code'] == 200 ) {
            return new BucketFile(rtrim($this->getDomain(),'/')."/".$bukFileName, $this);
        }
        throw new OssUploadException("上传失败");

    }


    /**
     * 上传一个本地文件
     * @param $fileName string 需要上传的文件名称
     * @param $bukFileName string 上传之后访问的文件地址
     * @return BucketFile
     * @throws \OSS\Core\OssException
     * @throws OssUploadException
     */
    public function putFile($fileName,$bukFileName){
        $bukFileName = $this->filterFileName($bukFileName);
        $rep = $this->getClient()
            ->uploadFile($this->getBucket(), $bukFileName, $fileName, $this->options);
        if (!empty($rep['info']) && $rep['info']['http_code'] == 200 ) {
            return new BucketFile(rtrim($this->getDomain(),'/')."/".$bukFileName, $this);

        }
        throw new OssUploadException("上传失败");
    }

    /**
     * 抓取远程文件
     * @param $url
     * @param $key
     * @param $expire
     * @param array $head
     * @return BucketFile
     * @throws OssUploadException
     * @throws \OSS\Core\OssException
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2022/03/18 10:23 |变更内容|
     */
    public function fetchFile($url,$key,$expire='',$head=[]){
        $head = array_merge( [
            'User-Agent'=>"km-wechat-Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.3 (KHTML, like Gecko)"
        ],$head);
        $key = $this->filterFileName($key);
        $cli = new \GuzzleHttp\Client([
            'connect_timeout'=>3,
            RequestOptions::HEADERS=>$head
        ]);

        $tempFIle = ($this->tempDir?:sys_get_temp_dir()).'/'.uniqid();
        $cli->get($url,['sink'=>$tempFIle]);
        if (!is_file($tempFIle) || filesize($tempFIle) <1 ) {
            throw new \Exception("下载文件{$url}失败");
        }
        if ($expire) {
            $this->setExpire($expire);
        }
        $file = $this->putFile($tempFIle,$key);
        try {
            @unlink($tempFIle);
        } catch (\Throwable $throwable) {
        }
        return $file;
    }

    public function getFcDomain(){
        //   protected $fcDomain = 'http://oss-alifn.kuaimenkeji.com';
        //        protected $fcInternalDomain = 'http://oss-alifn.kuaimenkeji.com';
        if (strpos($this->getEndpointPrivate(),'internal')!==false) {
            return $this->configArr['fcInternalDomain'] ?? $this->fcInternalDomain;
        }else{
            return $this->configArr['fcDomain'] ?? $this->fcDomain;
        }
    }

    /**
     * 设置HK 的URL地址
     * @param $url 外网地址
     * @param $fcInternalDomain  内网地址
     * @return $this
     * @author 阿豹
     */
    public function setFCDomain($url,$fcInternalDomain){
        $this->configArr['fcDomain']= $url;
        $this->configArr['fcInternalDomain']= $fcInternalDomain;
        return $this;
    }
    /**
     * 设置HK 的URL地址
     * @param $url
     * @param $internalUrl
     * @return $this
     * @author 阿豹
     */
    public function setFCDomainHK($url){
        $this->configArr['fcDomainHK']= $url;
        return $this;
    }
    public function getFcDomainHK(){
        //   protected $fcDomain = 'http://oss-alifn.kuaimenkeji.com';
        //        protected $fcInternalDomain = 'http://oss-alifn.kuaimenkeji.com';
        return $this->configArr['fcDomainHK'] ?? $this->fcDomainHk;
    }
    public function fetchFileByOrg($url,$key,$expire='',$header=[]){
       $fcUrl =$this->getFcDomain();
       return $this->fetchOrg($url,$key,$expire,$header,$fcUrl);
    }

    protected function fetchOrg($url,$key,$expire='',$header=[],$fcUrl){
        $t = time();
        $query = [
            'time'=>$t,
            'token'=>md5($t.'kmkj2022')
        ];
        $arr =['config'=>$this->getConfigArr(),'par'=>['url'=>$url,'key'=>$key,'expire'=>$expire,'header'=>$header]];
        $curl = new \GuzzleHttp\Client([RequestOptions::VERIFY=>false,RequestOptions::HTTP_ERRORS=>false]);
        $res = $curl->post($fcUrl,['query'=>$query,'body'=>json_encode($arr)]);

        $str =$res->getBody()->getContents();
        $data= json_decode($str,true);
        if (empty($data['data']['url'])) {
            throw new \Exception("上传文件 {$url}失败:$str");
        }
        return new BucketFile($data['data']['url'],$this);
    }
    public function fetchFileByOrgHK($url,$key,$expire='',$header=[]){
        $fcUrl =$this->getFcDomainHK();
        return $this->fetchOrg($url,$key,$expire,$header,$fcUrl);
    }
}