<?php


namespace kmkj\help;


use GuzzleHttp\Client;

/**
 * 查询摸个IP的归属地
 * Class IPAscription
 * @package kmkj\help
 */
class IPAscription
{
    
    /**
     * 获取 某个IP的定位
     * @param $ip
     * @return false|mixed|string
     * @User: 阿豹
     * @Date: 2020/8/6
     */
    public function getIPAscription($ip)
    {
        return $this->getIp1($ip);
    }
    private function getIp1($ip)
    {
        $cli = new Client();
        try {
            $rep = $cli->request("GET","https://apikey.net/?type=json&ip=".$ip);
            if ($rep->getStatusCode() !==200) {
                return $this->getIp2($ip);
            }
            $data = json_decode($rep->getBody()->getContents(),true);
            if (!empty($data['address'])) {
                return $data['address'];
            }
            throw new \Exception("下一个");
        } catch (\Exception $exception) {
            return $this->getIp2($ip);
        }
    }
    
    private function getIp2($ip)
    {
        $cli = new Client();
        try {
            $rep = $cli->request("GET","http://opendata.baidu.com/api.php?query={$ip}&co=&resource_id=6006&t=1433920989928&ie=utf8&oe=utf-8&format=json");
            if ($rep->getStatusCode() !==200) {
                return $this->getIp3($ip);
            }
            $data = json_decode($rep->getBody()->getContents(),true);
            if (!empty($data['data']['location'])) {
                return substr($data['data']['location'],0,-3);
            }
            throw new \Exception("下一个");
        } catch (\Exception $exception) {
            return $this->getIp3($ip);
        }
    }
    private function getIp3($ip)
    {
        $cli = new Client();
        try {
            $rep = $cli->request("GET","http://api.map.baidu.com/location/ip?ip={$ip}&ak=abDsBedrGw46lo1CyQuwZs9magjV5gSf&coor=");
            if ($rep->getStatusCode() !==200) {
                return '';
            }
            $data = json_decode($rep->getBody()->getContents(),true);
            if (!empty($data['content']['address'])) {
                return $data['content']['address'];
            }
            throw new \Exception("下一个");
        } catch (\Exception $exception) {
           return  '';
        }
    }
}