<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 11:43 AM
 */

namespace kmkj\oss\core;


use GuzzleHttp\RequestOptions;
use http\Client;
use kmkj\oss\client\MyOssClient;
use kmkj\oss\ex\OssUploadException;
use kmkj\oss\header\OssConst;
use OSS\OssClient;


/**
 * 阿里云的上传对象
 * Class Upload
 * @package kmkj\oss\core
 */
class Upload extends MyOssClient
{

    private $options =[];

    /**
     * 设置文件为私有
     * @return $this
     */
    public function setFilePrivate()
    {
        $this->setOption(OssClient::OSS_OBJECT_ACL,OssClient::OSS_ACL_TYPE_PRIVATE);
        return $this;
    }

    /**
     * 设置文件为公共读,权限写
     * @return $this
     */
    public function setFileOnlyRead(){
        $this->setOption(OssClient::OSS_OBJECT_ACL, OssClient::OSS_ACL_TYPE_PUBLIC_READ);
        return $this;
    }

    /**
     * 删除所有的选项值
     */
    public function clearOptions(){
        $this->options =[];
    }

    /**
     * 设置文件的过期时间
     * @param $value
     * @return $this
     */
    public function setExpire($value){
        $tag = OssConst::FILE_EXPIRE_TAG_NAME."=".urlencode($value);
        $this->setOption('x-oss-tagging',$tag);
        $this->setOption('expire_time',1);
        return $this;
    }

    /**
     * 设置一个选项
     * @param $key
     * @param $value
     * @return $this
     */
    public function setOption($key,$value){
        $this->options[OssClient::OSS_HEADERS][$key] = $value;
        return $this;
    }

    /**
     * 是否有设置某个options
     * @param $key
     * @return bool
     */
    public function hasOption($key){
        return isset( $this->options[OssClient::OSS_HEADERS][$key]);
    }

    /**
     * 在上传之前处理文件的路径
     * @param $bukFileName
     * @return string
     */
    protected function filterFileName($bukFileName)
    {
        if ($this->hasOption('expire_time')) {
            $bukFileName = OssConst::FILE_EXPIRE__PREFIX.'/'.$bukFileName;
        }
        return $bukFileName;
    }
    /**
     * 上传一个字符串到oss上上面去
     * @param $bukFileName string 上传之后访问的文件地址
     * @param $content string 需要上传的字符串
     * @return BucketFile
     * @throws OssUploadException
     * @throws \OSS\Core\OssException
     */
    public function putObject($content,$bukFileName)
    {
        $bukFileName = $this->filterFileName($bukFileName);
        $rep = $this->getClient()
            ->putObject($this->getBucket(), $bukFileName,$content, $this->options);
        if (!empty($rep['info']) && $rep['info']['http_code'] == 200 ) {
            return new BucketFile(rtrim($this->getDomain(),'/')."/".$bukFileName, $this);
        }
        throw new OssUploadException("上传失败");

    }


    /**
     * 上传一个本地文件
     * @param $fileName string 需要上传的文件名称
     * @param $bukFileName string 上传之后访问的文件地址
     * @return BucketFile
     * @throws \OSS\Core\OssException
     * @throws OssUploadException
     */
    public function putFile($fileName,$bukFileName){
        $bukFileName = $this->filterFileName($bukFileName);
        $rep = $this->getClient()
            ->uploadFile($this->getBucket(), $bukFileName, $fileName, $this->options);
        if (!empty($rep['info']) && $rep['info']['http_code'] == 200 ) {
            return new BucketFile(rtrim($this->getDomain(),'/')."/".$bukFileName, $this);

        }
        throw new OssUploadException("上传失败");
    }

    /**
     * 抓取远程文件
     * @param $url
     * @param $key
     * @param $expire
     * @param array $head
     * @return BucketFile
     * @throws OssUploadException
     * @throws \OSS\Core\OssException
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2022/03/18 10:23 |变更内容|
     */
    public function fetchFile($url,$key,$expire='',$head=[]){
        if (empty($head)) {
            $head= [
                'user-agent'=>"km-wechat-Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.3 (KHTML, like Gecko)"
            ];
        }
        $key = $this->filterFileName($key);
        $cli = new \GuzzleHttp\Client([
            'connect_timeout'=>3,
            RequestOptions::HEADERS=>$head
        ]);

        $tempFIle = sys_get_temp_dir().'/'.uniqid();
        $cli->get($url,['sink'=>$tempFIle]);
        if (!is_file($tempFIle) || filesize($tempFIle) <1 ) {
            throw new \Exception("下载文件{$url}失败");
        }
        if ($expire) {
            $this->setExpire($expire);
        }
        return $this->putFile($tempFIle,$key);
    }

    public function fetchFileByOrg($url,$key,$expire='',$header=[]){
        if ($this->getEndpointPrivate()) {
            $url='https://phppack-oss-reptile-xnqjnsyuwj.cn-shenzhen-vpc.fcapp.run';
        }else{
            $url = 'https://phppack-oss-reptile-xnqjnsyuwj.cn-shenzhen.fcapp.run';
        }
        $arr =['config'=>$this->getConfigArr(),'par'=>['url'=>$url,'key'=>$key,'expire'=>$expire,'header'=>$header]];
        $curl = new \GuzzleHttp\Client();
        $res = $curl->post($url,['body'=>json_encode($arr)]);
        $str =$res->getBody()->getContents();
        $data= json_decode($str,true);
        if (empty($data['data']['url'])) {
            throw new \Exception("上传文件 {$url}失败");
        }
        return new BucketFile($data['data']['url'],$this);
    }
}