<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/9
 * Time: 6:11 PM
 */

namespace kmkj\oss\header;


class OssConst
{
    //============ 文件过期时间  ============
    // 一天过期
    const FILE_EXPIRE_1D = '1d';
    // 七天自动过期
    const FILE_EXPIRE_7D = '7d';
    // 30天自动过期
    const FILE_EXPIRE_30D = '30d';
    // 3个月自动过期
    const FILE_EXPIRE_3m = '3m';
    // 1年自动过期
    const FILE_EXPIRE_1y = '1y';
    // 文件过期的前缀
    const FILE_EXPIRE_TAG_NAME = 'expire';
    // 设置文件自动过期属性的文件夹前缀
    const FILE_EXPIRE__PREFIX = 'expire';

    //============ ContentType  ============
    //========== 图片格式 ==========
    const CONTENT_TYPE_PNG = 'image/png';
    const CONTENT_TYPE_JPG = 'image/jpeg';
    const CONTENT_TYPE_JPEG = 'image/jpeg';
    const CONTENT_TYPE_GIF = 'image/gif';
    const CONTENT_TYPE_WEBP = 'image/webp';
    const CONTENT_TYPE_BMP = 'image/bmp';
    const CONTENT_TYPE_SVG = 'image/svg+xml';
    const CONTENT_TYPE_ICO = 'image/x-icon';

    //========== 视频格式 ==========
    const CONTENT_TYPE_MP4 = 'video/mp4';
    const CONTENT_TYPE_MOV = 'video/quicktime';
    const CONTENT_TYPE_WEBM = 'video/webm';
    const CONTENT_TYPE_AVI = 'video/x-msvideo';
    const CONTENT_TYPE_FLV = 'video/x-flv';
    const CONTENT_TYPE_MKV = 'video/x-matroska';
    const CONTENT_TYPE_3GP = 'video/3gpp';
    const CONTENT_TYPE_WMV = 'video/x-ms-wmv';

    //========== 音频格式 ==========
    const CONTENT_TYPE_MP3 = 'audio/mpeg';
    const CONTENT_TYPE_WAV = 'audio/wav';
    const CONTENT_TYPE_M4A = 'audio/mp4';
    const CONTENT_TYPE_FLAC = 'audio/flac';
    const CONTENT_TYPE_AAC = 'audio/aac';
    const CONTENT_TYPE_OGG = 'audio/ogg';
    const CONTENT_TYPE_AIFF = 'audio/aiff';
    const CONTENT_TYPE_WMA = 'audio/x-ms-wma';

    //========== Web 相关格式 ==========
    const CONTENT_TYPE_HTML = 'text/html';
    const CONTENT_TYPE_CSS = 'text/css';
    const CONTENT_TYPE_JS = 'application/javascript';
    const CONTENT_TYPE_JSON = 'application/json';
    const CONTENT_TYPE_PDF = 'application/pdf';
    const CONTENT_TYPE_XML = 'application/xml';
    const CONTENT_TYPE_ZIP = 'application/zip';
    const CONTENT_TYPE_RAR = 'application/x-rar-compressed';
    const CONTENT_TYPE_TXT = 'text/plain';

    //========== 流式媒体格式 ==========
    const CONTENT_TYPE_HLS = 'application/vnd.apple.mpegurl';
    const CONTENT_TYPE_MPEGTS = 'video/mp2t';
    const CONTENT_TYPE_OGV = 'video/ogg';
    const CONTENT_TYPE_M3U8 = 'application/vnd.apple.mpegurl';

    //============ ContentType 数组分类  ============
    public static $CONTENT_TYPES_IMAGE = [
        self::CONTENT_TYPE_PNG,
        self::CONTENT_TYPE_JPG,
        self::CONTENT_TYPE_JPEG,
        self::CONTENT_TYPE_GIF,
        self::CONTENT_TYPE_WEBP,
        self::CONTENT_TYPE_BMP,
        self::CONTENT_TYPE_SVG,
        self::CONTENT_TYPE_ICO,
    ];

    public static $CONTENT_TYPES_VIDEO = [
        self::CONTENT_TYPE_MP4,
        self::CONTENT_TYPE_MOV,
        self::CONTENT_TYPE_WEBM,
        self::CONTENT_TYPE_AVI,
        self::CONTENT_TYPE_FLV,
        self::CONTENT_TYPE_MKV,
        self::CONTENT_TYPE_3GP,
        self::CONTENT_TYPE_WMV,
        self::CONTENT_TYPE_OGV,
    ];

    public static $CONTENT_TYPES_AUDIO = [
        self::CONTENT_TYPE_MP3,
        self::CONTENT_TYPE_WAV,
        self::CONTENT_TYPE_M4A,
        self::CONTENT_TYPE_FLAC,
        self::CONTENT_TYPE_AAC,
        self::CONTENT_TYPE_OGG,
        self::CONTENT_TYPE_AIFF,
        self::CONTENT_TYPE_WMA,
    ];

    //============ 权限  ============
    // 仅上传权限
    const STS_POLICY_ACTION_PUT = '"oss:Put*"';
    // 只读权限
    const STS_POLICY_ACTION_GET = '"oss:Get*"';
    // 读写权限
    const STS_POLICY_ACTION_ALL = '"oss:Put*","oss:Get*"';


    // oss
    const CONFIG_ROLE_NAME = 'oss';
}