<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/7
 * Time: 5:46 PM
 */
namespace kmkj\oss;
/**
 * Class AliOss
 */
class AliOss
{
    /**
     * 阿里云oss的上传对象
     * @var \kmkj\oss\core\Upload
     */
    private $upload;

    private $tst;
    private $cnf;

    /**
     * 获取 upLoad对象
     * @return \kmkj\oss\core\Upload
     * @throws \kmkj\mq\oss\ex\OssException
     */
    public function getUpload(){
        if (empty($this->upload)) {
            $this->upload = new \kmkj\oss\core\Upload();
            $this->upload->setConfig($this->cnf);
        }
        return $this->upload;
    }

    /**
     * @return \kmkj\oss\core\Sts
     * @throws \AlibabaCloud\Client\Exception\ClientException
     */
    public function getTst(){
        if (empty($this->tst)) {
            $this->tst = new \kmkj\oss\core\Sts();
            $this->tst->setConfig($this->cnf);
        }
        return $this->tst;
    }


    /**
     * 设置配置文件
     * @param $conf
     * @throws \kmkj\oss\ex\OssException
     */
    public function setConfig($conf){
        $this->cnf = $conf;
        $this->getUpload()->setConfig($conf);
    }

    /**
     * AliOss constructor.
     * @param string $config
     * @throws \kmkj\oss\ex\OssException
     */
    public function __construct($config='oss')
    {
        $this->setConfig($config);
    }

    /**
     *
     * 获取 oss客户表的 实例
     * @param $conf
     * @return static
     * @throws ex\OssException
     */
    public static function getInstance($conf){
        $obj = new static($conf);
        return $obj;
    }
}