<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/7
 * Time: 6:17 PM
 */

namespace kmkj\oss\client;

use kmkj\mq\oss\ex\OssException;


/**
 * 阿里云 oss的操作类
 * @link https://help.aliyun.com/document_detail/85580.html?spm=a2c4g.11186623.6.1054.7eda7f5eKJyjkW
 * Class ossClient
 * @package kmkj\oss\ossClient
 */
abstract class Client
{

    /**
     * @var string
     */
    private $accessKeyId = "";
    /**
     * @var string
     */
    private $accessKeySecret = "";
    /**
     * 阿里云的存储的的访问域名
     * @link https://help.aliyun.com/document_detail/31837.html?spm=a2c4g.11186623.6.584.2bc47815uZmE1P
     * @var string
     */
    private $endpoint = "";

    /**
     * @return string
     */
    public function getAccessKeyId()
    {
        return $this->accessKeyId;
    }


    /**
     * @param string $accessKeyId
     * @return static
     */
    public function setAccessKeyId($accessKeyId)
    {
        $this->accessKeyId = $accessKeyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAccessKeySecret()
    {
        return $this->accessKeySecret;
    }

    /**
     * @param string $accessKeySecret
     * @return static
     */
    public function setAccessKeySecret($accessKeySecret)
    {
        $this->accessKeySecret = $accessKeySecret;
        return $this;
    }

    /**
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * @param string $endpoint
     * @return static
     */
    public function setEndpoint($endpoint)
    {
        $this->endpoint = $endpoint;
        return $this;
    }

    /**
     * @return string
     */
    public function getConfigName()
    {
        return $this->configName;
    }

    /**
     * @param string $configName
     */
    public function setConfigName($configName)
    {
        $this->configName = $configName;
        return $this;
    }


    /**
     * @param string $conf
     * @throws OssException
     * @return  static
     */
    abstract  public function setConfig($conf);

    /**
     * 获取一个阿里云的连接对象
     * @return object
     * @throws \OSS\Core\OssException
     */
    abstract public function getClient();
}