<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/10
 * Time: 10:34 AM
 */

namespace kmkj\oss\core;


use kmkj\oss\AliOss;
use kmkj\oss\client\MyOssClient;
use kmkj\oss\header\OssConst;

class BucketFile
{
    /**
     * @var string
     */
    protected $url;
    /**
     * @var string path
     */
    protected $path;

    protected $host;
    /**
     *
     * @var MyOssClient
     */
    protected $client;

    /**
     * @return mixed
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param mixed $url
     */
    public function setUrl($url)
    {

        $data = parse_url($url);
        $this->path = $data['path'];
        $this->host = $data['host'];
        $this->url = $url;
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @return MyOssClient
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @param MyOssClient $client
     */
    public function setClient($client)
    {
        $this->client = $client;
    }

    /**
     * BucketFile constructor.
     * @param string $url
     * @param MyOssClient $client
     */
    public function __construct($url='',$client=null)
    {
        if ($url)
            $this->setUrl($url);

        if ($client)
            $this->setClient($client);
    }

    /**
     * 设置一个配置文件
     * @param $config array|string
     */
    public function setConfig($config){
        $cli = new MyOssClient();
        $this->client = $cli->setConfig($config);
    }

    /**
     * 给一个图片url签名
     * @param int $timeOut
     * @return string
     * @throws \OSS\Core\OssException
     */
    public function signUrl($timeOut=1800){

        if (!$this->getClient()->getSecurityToken()) {
            // 如果不是临时的的秘钥那么使用Tst 创建一个
            $tempUser = AliOss::getInstance($this->getClient()->getConfigName())
            ->getTst()->createTempUser(OssConst::STS_POLICY_ACTION_GET);
            $client = clone $this->getClient();
            $client->setAccessKeyId($tempUser['AccessKeyId']);
            $client->setAccessKeySecret($tempUser['AccessKeySecret']);
            $client->setSecurityToken($tempUser['SecurityToken']);
            $this->setClient($client);
        }
        $res=  $this->client->getClient()->signUrl($this->client->getBucket(), ltrim($this->getPath(),'/'), $timeOut);
        $urlData = parse_url($res);
        $urlData['host'] = $this->host;
        $url = "{$urlData['scheme']}://{$urlData['host']}{$urlData['path']}?{$urlData['query']}";
        return $url;
    }
    public function __toString()
    {
        return $this->getUrl();
    }

}