<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 4:34 PM
 */

namespace kmkj\common;


/**
 * @author 阿豹
 * 兼容处理  tp3.2 tp5.1 easySwoole 获取配置文件代理类
 *
 * Class Config
 * @package kmkj\common
 */
class ConfigByPack extends Config
{
    /**
     * @var string 配置所属的模块
     */
    protected $module;

    /**
     * @var string
     */
    protected $prefix;

    /**
     * 当前运行在哪一个模块下面
     * @var null |string
     */
    protected  $project =null;
    
    public function __construct($prefix,$module='')
    {
        $this->prefix =  $prefix;
        $this->module =  $module;
    }

    public function getConfig($key){
        $Kstr = "";
        if($this->module) $Kstr .= $this->module.".";
        if($this->prefix) $Kstr .= $this->prefix.".";
        $Kstr .= $key;
        switch ($this->getProject()) {
            case 'easySwoole':
               
                $instance = \EasySwoole\EasySwoole\Config::getInstance();
                return $instance->getConf($Kstr);
                break;
            case 'tp51':
                if ($this->module=='app') {
                    $Kstr = substr($Kstr,4);
                }
                return config($Kstr);
                break;
            case 'tp32':
                return C(strtoupper(str_replace('.','_',$Kstr)));
                break;
        }
    }
}