<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 6:37 PM
 */

namespace kmkj\oss\client;


use kmkj\common\Config;
use OSS\Credentials\StaticCredentialsProvider;
use OSS\OssClient;

class MyOssClient extends Client
{


    /**
     * 临时访问的token
     * @var string
     */
    private $securityToken = null;

    /**
     * 设置临时的token
     * @param $token
     * @return $this
     */
    public function setSecurityToken($token)
    {
        debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS,1);
        $this->securityToken = $token;
        return $this;
    }

    /**
     * 获取临时的token
     * @return mixed
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }

    /**
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * @param string $domain
     */
    public function setDomain($domain)
    {
        $this->domain = $domain;
        return $this;
    }


    /**
     * 我们自己的访问域名(cdn加速的域名)
     * @var string
     */
    private $domain = '';
    
    protected $region = '';

    /**
     * 存储空间
     * @var string
     */
    private $bucket = "";


    protected $configArr=[];
    /**
     * @return string
     * @return static
     */
    public function getBucket()
    {
        return $this->bucket;
    }

    /**
     * @param string $bucket
     */
    public function setBucket($bucket)
    {
        $this->bucket = $bucket;
        return $this;
    }

    /**
     * 设置配置文件
     * @param string $conf
     * @return $this|static
     */
    public function setConfig($conf)
    {
        $this->setConfigName($conf);
        $cnfArr = [];
        if (!is_array($conf)) {
            $configObj = new Config($conf,'ali');
            $cnfArr['accessKeyId'] = $configObj->getConfig('accessKeyId');
            $cnfArr['accessKeySecret'] = $configObj->getConfig('accessKeySecret');
            $cnfArr['bucket'] = $configObj->getConfig('bucket');
            $cnfArr['endpoint'] = $configObj->getConfig('endpoint');
            $cnfArr['regionId'] = $configObj->getConfig('regionId');
            $cnfArr['domain'] = $configObj->getConfig('bucket_domain');
        }else{
            $cnfArr = $conf;
        }
        $this->setAccessKeyId($cnfArr['accessKeyId'])
            ->setAccessKeySecret($cnfArr['accessKeySecret'])
            ->setBucket($cnfArr['bucket'])
            ->setEndpoint($cnfArr['endpoint'])
            ->setDomain($cnfArr['domain'])
            ->setRegion($cnfArr['regionId']);
        if (!empty($cnfArr['securityToken'])){
            $this->setSecurityToken($cnfArr['securityToken']);
        }
        $this->configArr =$cnfArr;
        return $this;
    }

    public function getConfigArr(){
        return $this->configArr;
    }
    
    public function setRegion($region): MyOssClient
    {
        $this->region = $region;
        return $this;
    }
   
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * 获取阿里云的client对象
     * @return object|\OSS\OssClient
     * @throws \OSS\Core\OssException
     */
    public function getClient()
    {
        
        $provider = new StaticCredentialsProvider($this->getAccessKeyId(),$this->getAccessKeySecret(),$this->getSecurityToken());
        
        $config = array(
            "provider" => $provider,
            "endpoint" => $this->getEndpointPrivate(),
            "signatureVersion" => OssClient::OSS_SIGNATURE_VERSION_V4,
            "region"=> $this->getRegion()
        );
        
        return new OssClient($config);
    }
}