<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2019/11/13
 * Time: 4:03 PM
 */

namespace kmkj\mq\consumer;


use kmkj\mq\ali\aliClient;

class consumer extends aliClient
{

    protected $currTopic;

    public function __construct()
    {
        $this->setClient();
    }

    /**
     * @var \MQ\MQConsumer
     */
    protected $consumer;
    /**
     * 获取一个消费者对象
     * @param $topic
     * @param string $tag
     * @return \MQ\MQConsumer
     */
    public function getConsumer($topic,$tag=''){
        $this->currTopic = $topic;
        $this->consumer = $this->getClient()->getConsumer($this->mqId,$topic,$this->groupId,$tag);
        return $this->consumer;
    }

    /**
     * @param $event
     * @param int $maxTask
     * @param int $timeOut
     * @return \MQ\Model\Message
     */
    public function listen($event,$maxTask=3,$timeOut=10){

        $event = explode('.',$event);
        while (true) {
            $event[1] = isset($event[1])?$event[1]:'';
            $consumer = $this->getConsumer($event[0],$event[1]);
            try {
                $messages = $consumer->consumeMessage($maxTask,$timeOut);
            } catch (\Exception $e) {
                if ($e instanceof \MQ\Exception\MessageNotExistException) {
                    // 没有消息可以消费，接着轮询
                    printf("No message, contine long polling!RequestId:%s\n", $e->getRequestId());
                    continue;
                }
                print_r($e->getMessage() . "\n");
                sleep(3);
                continue;
            }

            return $messages;
        }
    }


    /**
     * 完成一条
     * @param $receiptHandle
     */
    public function finish($receiptHandle)
    {
        try {
            $this->consumer->ackMessage([$receiptHandle]);
        } catch (\Exception $e) {
            if ($e instanceof \MQ\Exception\AckMessageException) {
                // 某些消息的句柄可能超时了会导致确认不成功
                printf("Ack Error, RequestId:%s\n", $e->getRequestId());
                foreach ($e->getAckMessageErrorItems() as $errorItem) {
                    printf("\tReceiptHandle:%s, ErrorCode:%s, ErrorMsg:%s\n", $errorItem->getReceiptHandle(), $errorItem->getErrorCode(), $errorItem->getErrorCode());
                }
            }
            print_r($e->getMessage() . "\n");
            sleep(3);
        }

    }

    /**
     * 完成所有的任务
     * @param $receiptHandles
     */
    public function finishAll($receiptHandles)
    {
        try {
            $this->consumer->ackMessage($receiptHandles);
        } catch (\Exception $e) {
            if ($e instanceof \MQ\Exception\AckMessageException) {
                // 某些消息的句柄可能超时了会导致确认不成功
                printf("Ack Error, RequestId:%s\n", $e->getRequestId());
                foreach ($e->getAckMessageErrorItems() as $errorItem) {
                    printf("\tReceiptHandle:%s, ErrorCode:%s, ErrorMsg:%s\n", $errorItem->getReceiptHandle(), $errorItem->getErrorCode(), $errorItem->getErrorCode());
                }
            }
            print_r($e->getMessage() . "\n");
            sleep(3);
        }
    }
}