<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 6:43 PM
 */

namespace kmkj\oss\client;

use AlibabaCloud\Client\AlibabaCloud;
use AlibabaCloud\Client\Request\RpcRequest;
use kmkj\common\Config;

/**
 * 临时授权的client
 * @link https://help.aliyun.com/document_detail/28756.html?spm=a2c4g.11186623.6.792.191167bdXSHP1m
 * Class TstClient
 * @package kmkj\oss\client
 */
class TstClient extends Client
{

    /**
     * @return string
     */
    public function getRegionId()
    {
        return $this->regionId;
    }
    /**
     * @link https://help.aliyun.com/document_detail/66053.html?spm=a2c4g.11186623.6.795.330e39afwwDQuc
     * @var string 地域
     */
    private $regionId ;

    /**
     * 配置文件的散列值, 阿里配置文件为静态的hash
     * @var string
     */
    private $name;

    private $bucket;
    protected $roleArn;
    /**
    * @return string
    */
    public function getBucket()
    {
        return $this->bucket;
    }
    /**
     * @return string
     */
    public function setBucket($name)
    {
        $this->bucket=$name;
        return $this;
    }
    /**
     * @param string $regionId
     */
    public function setRegionId($regionId)
    {
        $this->regionId = $regionId;
        return $this;
    }


    public function getName(){
        return $this->name;
    }

    public function setName($name)
    {
        $this->name=$name;
        return $this;
    }

    public function setRoleArn($str){
        $this->roleArn = urldecode($str);
        return $this;
    }
    public function getRoleArn(){
        return $this->roleArn;
    }
    /**
     * @param string $conf
     * @return $this|static
     * @throws \AlibabaCloud\Client\Exception\ClientException
     */
    public function setConfig($conf)
    {
        $cnfArr = [];
        if (!is_array($conf)) {
            $configObj = new Config($conf,'ali');
            $cnfArr['accessKeyId']= $configObj->getConfig('accessKeyId');
            $cnfArr['accessKeySecret']= $configObj->getConfig('accessKeySecret');
            $cnfArr['endpoint']= $configObj->getConfig('endpoint');
            $cnfArr['bucket']= $configObj->getConfig('bucket');
            $cnfArr['roleArn']= $configObj->getConfig('roleArn');
        }else{
            $cnfArr = $conf;
        }
        $this->setName(md5(json_encode($cnfArr)));

        // 设置配置
        $this->setAccessKeyId($cnfArr['accessKeyId'])
            ->setAccessKeySecret($cnfArr['accessKeySecret'])
            ->setEndpoint($cnfArr['endpoint'])
            ->setRegionId($cnfArr['regionId'])
            ->setRoleArn($cnfArr['roleArn'])
            ->setName($this->getName())
            ->setBucket($conf['bucket']);

        // 注册阿里云的 client变量列表
        AlibabaCloud::accessKeyClient($this->getAccessKeyId(), $this->getAccessKeySecret())
            ->regionId($this->getRegionId())
            ->name($this->getName());
        return $this;
    }

    /**
     * @see https://api.aliyun.com/#/?product=Sts&version=2015-04-01&api=AssumeRole&tab=DEMO&lang=JAVA
     * 获取一个TSTd的client对象对象
     * @return RpcRequest|object
     * @throws \AlibabaCloud\Client\Exception\ClientException
     */
    public function getClient()
    {
        $request = new RpcRequest();
        $request->client($this->name);
        $request->product('Sts')
            ->scheme('https')
            // ->scheme('https') // https | http
            ->version('2015-04-01')
            ->action('AssumeRole')
            ->method('POST')
            ->host('sts.aliyuncs.com');
        return $request;
    }
}