<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/10
 * Time: 10:34 AM
 */

namespace kmkj\oss\core;


use kmkj\oss\client\MyOssClient;

class BucketFile
{

    /**
     * @var string
     */
    protected $url;
    /**
     * @var string path
     */
    protected $path;

    protected $host;
    /**
     *
     * @var MyOssClient
     */
    protected $client;

    /**
     * @return mixed
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param mixed $url
     */
    public function setUrl($url)
    {

        $data = parse_url($url);
        $this->path = $data['path'];
        $this->host = $data['host'];
        $this->url = $url;
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @return MyOssClient
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @param MyOssClient $client
     */
    public function setClient($client)
    {
        $this->client = $client;
    }

    /**
     * BucketFile constructor.
     * @param string $url
     * @param MyOssClient $client
     */
    public function __construct($url='',$client=null)
    {
        if ($url)
            $this->setUrl($url);

        if ($client)
            $this->setClient($client);
    }

    /**
     * 设置一个配置文件
     * @param $config array|string
     */
    public function setConfig($config){
        $cli = new MyOssClient();
        $this->client = $cli->setConfig($config);
    }

    /**
     * 给一个图片url签名
     * @param int $timeOut
     * @return string
     * @throws \OSS\Core\OssException
     */
    public function signUrl($timeOut=1800){

        $res=  $this->client->getClient()->signUrl($this->client->getBucket(), ltrim($this->getPath(),'/'), $timeOut);
        $urlData = parse_url($res);
        $urlData['host'] = $this->host;
        $url = "{$urlData['scheme']}://{$urlData['host']}{$urlData['path']}?{$urlData['query']}";
        return $url;
    }
    public function __toString()
    {
        return $this->getUrl();
    }

}