<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 4:57 PM
 */

namespace kmkj\oss\core;

use AlibabaCloud\Client\AlibabaCloud;
use kmkj\mq\oss\ex\OssException;
use kmkj\oss\client\TstClient;
use kmkj\oss\header\OssConst;

/**
 * @link https://help.aliyun.com/document_detail/66053.html?spm=a2c4g.11186623.2.11.6e2a39afnLF9gf#reference-sdg-3pv-xdb
 * Class Sts
 * @package kmkj\oss\core
 */
class Sts extends TstClient
{

    private $expireTime = 900;
    private $regionId = 'cn-shenzhen';

    private $roleArn ='';

    /**
     * DurationSeconds  L过期时间
     * @link 代码编辑器  https://api.aliyun.com/#/?product=Sts&version=2015-04-01&api=AssumeRole&params={}&tab=DEMO&lang=PHP
     * @link 授权策略编辑器 http://gosspublic.alicdn.com/ram-policy-editor/index.html?spm=a2c4g.11186623.2.10.5b8a3eb1BYXNqB
     * @throws \AlibabaCloud\Client\Exception\ClientException
     */
    public function createTempUser($action,$path='*'){


        $request = $this->getClient();
        $policy = <<<json
{
  "Version": "1",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
       {$action}
      ],
      "Resource": [
        "acs:oss:*:*:{$this->getBucket()}/{$path}"
      ],
      "Condition": {}
    }
  ]
}
json;


        $options =[
            'query' => [
                'RegionId' => $this->regionId,
                'RoleArn' =>  $this->getRoleArn(),//'acs:ram::1848687233876471:role/oss',
                'RoleSessionName' => OssConst::CONFIG_ROLE_NAME,
                'DurationSeconds' => $this->expireTime,
                'Policy' => $policy,
            ]
        ];

        $request->client($this->getName());
        $result = $request->options($options)->request();
        $res = $result->toArray();

        if (empty($res['Credentials'])) {
            throw new \kmkj\oss\ex\OssException("获取临时token失败");
        }
        return $res['Credentials'];
    }
}