<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 4:57 PM
 */

namespace kmkj\oss\core;

use AlibabaCloud\Client\AlibabaCloud;
use kmkj\oss\client\TstClient;
use kmkj\oss\ex\OssException;
use kmkj\oss\header\OssConst;

/**
 * @link https://help.aliyun.com/document_detail/66053.html?spm=a2c4g.11186623.2.11.6e2a39afnLF9gf#reference-sdg-3pv-xdb
 * Class Sts
 * @package kmkj\oss\core
 */
class Sts extends TstClient
{

    private $expireTime = 900;

    protected $roleArn ='';

    public function setExpireTime($timeOut)
    {
        if (!is_numeric($timeOut)) {
            throw new OssException("过期时间只能是数字");
        }
        $this->expireTime = $timeOut;
        return $this;
    }
    /**
     * @param $action string 授权读写权限
     * @param $path string 授权路径
     * @link 代码编辑器  https://api.aliyun.com/#/?product=Sts&version=2015-04-01&api=AssumeRole&params={}&tab=DEMO&lang=PHP
     * @link 授权策略编辑器 http://gosspublic.alicdn.com/ram-policy-editor/index.html?spm=a2c4g.11186623.2.10.5b8a3eb1BYXNqB
     * @throws \AlibabaCloud\Client\Exception\ClientException
     * @throws \AlibabaCloud\Client\Exception\ServerException
     * @throws \kmkj\oss\ex\OssException
     */
    public function createTempUser($action,$path='*'){


        $request = $this->getClient();
        $policy = <<<json
{
  "Version": "1",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
       {$action}
      ],
      "Resource": [
        "acs:oss:*:*:{$this->getBucket()}/{$path}"
      ],
      "Condition": {}
    }
  ]
}
json;


        $options =[
            'query' => [
                'RegionId' => $this->getRegionId(),
                'RoleArn' =>  $this->getRoleArn(),//'acs:ram::1848687233876471:role/oss',
                'RoleSessionName' => $this->getRoleName(),
                'DurationSeconds' => $this->expireTime,
                'Policy' => $policy,
            ]
        ];

        $request->client($this->getName());
        $result = $request->options($options)->request();
        $res = $result->toArray();

        if (empty($res['Credentials'])) {
            throw new OssException("获取临时token失败");
        }
        return $res['Credentials'];
    }
}