<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2019/11/13
 * Time: 4:11 PM
 */

namespace kmkj\mq\kmkj\mq\ali;

use MQ\MQClient;

class aliClient
{

    protected $mqId=null;

    protected $groupId;

    /**
     * @var MQClient
     */
    protected $client;

    public function setClient($conf=''){

        if (!is_array($conf)) {
            $conf = $this->getConfig($conf);
        }
        $this->client = new MQClient($conf['domain'],$conf['accessId'],$conf['accessKey']);
        $this->mqId = $conf['mq_id'];
        $this->groupId = isset($conf['groupId'])?$conf['groupId']:'GID_content';
    }

    /**
     * @return MQClient
     */
    public function getClient(){
        return $this->client;
    }

    /**
     * @param string $conf
     * @return array
     */
    public function getConfig($conf=''){
        $ret=[];
        if(defined('THINK_VERSION')){
            $ret['domain'] = C('mq_domain','');
            $ret['accessId'] = C('mq_accessKey','');
            $ret['accessKey'] = C('mq_accessKey','');
            $ret['mq_id'] = C('mq_id','');
        }elseif (class_exists('think\app')){
            // tp5 的配置加载
            $ret['domain'] = env('mq.domain','');
            $ret['accessId'] = env('mq.accessKey','');
            $ret['accessKey'] = env('mq.secretKey','');
            $ret['mq_id'] = env('mq.id','');

        }else{
            $ret = require './config.php';
        }

        return $ret;
    }
}