<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2019/11/12
 * Time: 5:05 PM
 */

namespace kmkj\mq\producer;
use MQ\Model\TopicMessage;

/**
 * Class Timer
 * @package kmkj\mq\producer
 * @method push($eventName,$data,$time,$msgKey='') static 时间戳为毫秒级别
 * @method pushYmd($eventName,$data,$YmdHis,$msgKey='') static 时间戳为毫秒级别
 */
class timerEvent extends product
{
    /**
     * 返回消息keys
     * @param $name
     * @param $data
     * @param $YmdHis string
     * @param $msgKey
     * @return string|void
     */
    public function _pushYmd($name, $data,$YmdHis,$msgKey='')
    {
        $this->method=__METHOD__;
        $this->fnData=func_get_args();

        $event = explode('.',$name);
        $msg = new TopicMessage($this->pareData($data));
        $msg->setStartDeliverTime(strtotime($YmdHis) * 1000 );
        if (isset($event[1])) {
            $msg->setMessageTag($event[1]);
        }
        if ($msgKey) {
            $msg->setMessageKey($msgKey);
        }else{
            $key = date('YmdHis').$name;
            $msg->setMessageKey($key);
        }
        $product = $this->getProduct($event[0]);
        $result =  $this->tryPush([$product,'publishMessage'],[$msg]);
        if ($result) {
            return $result->getMessageId();
        }
        return '';

    }

    /**
     * 返回消息keys
     * @param $name
     * @param $data
     * @param $time int 毫秒级的时间戳
     * @param $msgKey
     * @return string|void
     */
    public function _push($name, $data,$time,$msgKey='')
    {

        $this->method=__METHOD__;
        $this->fnData=func_get_args();

        $event = explode('.',$name);
        $msg = new TopicMessage($this->pareData($data));
        $msg->setStartDeliverTime(time()*1000 + $time );
        if (isset($event[1])) {
            $msg->setMessageTag($event[1]);
        }
        if ($msgKey) {
            $msg->setMessageKey($msgKey);
        }
        $product = $this->getProduct($event[0]);
        $result =  $this->tryPush([$product,'publishMessage'],[$msg]);
        if ($result) {
            return $result->getMessageId();
        }
        return '';

    }
}