<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/7
 * Time: 6:17 PM
 */

namespace kmkj\oss\client;

use kmkj\common\Ping;
use kmkj\mq\oss\ex\OssException;


/**
 * 阿里云 oss的操作类
 * @link https://help.aliyun.com/document_detail/85580.html?spm=a2c4g.11186623.6.1054.7eda7f5eKJyjkW
 * Class ossClient
 * @package kmkj\oss\ossClient
 */
abstract class Client
{

    /**
     * @var string
     */
    private $accessKeyId = "";
    /**
     * @var string
     */
    private $accessKeySecret = "";
    /**
     * 阿里云的存储的的访问域名
     * @link https://help.aliyun.com/document_detail/31837.html?spm=a2c4g.11186623.6.584.2bc47815uZmE1P
     * @var string
     */
    private $endpoint = "";

    protected $endpointPrivate='';
    /**
     * @return string
     */
    public function getAccessKeyId()
    {
        return $this->accessKeyId;
    }


    /**
     * @param string $accessKeyId
     * @return static
     */
    public function setAccessKeyId($accessKeyId)
    {
        $this->accessKeyId = $accessKeyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAccessKeySecret()
    {
        return $this->accessKeySecret;
    }

    /**
     * @param string $accessKeySecret
     * @return static
     */
    public function setAccessKeySecret($accessKeySecret)
    {
        $this->accessKeySecret = $accessKeySecret;
        return $this;
    }
    /**
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * 获取内网的域名
     * @return string
     * @User: 阿豹
     * @Date: 2020/9/17
     */
    public function getEndpointPrivate(){
        // $this->endpoint = 'kmkj.devstatic.bxdaka.com';
        if ($this->endpointPrivate) {
            return $this->endpointPrivate;
        }
        if (strpos($this->endpoint,'http')  === false) {
            $this->endpoint='http://'.$this->endpoint;
        }
        if (strrpos($this->endpoint,"-internal") ===false) {
            $host=  parse_url($this->endpoint,PHP_URL_HOST);
            $scheme=  parse_url($this->endpoint,PHP_URL_SCHEME);
            $filename =sys_get_temp_dir().'/kmkj_oss_'.$host.'.json';
            $hostArr = explode('.',$host);
            // 拼接为内网域名
            $hostArr[0].='-internal';
            $host =implode('.',$hostArr);
            $isInternal=false;
            // 获取文件类容
            $data=[];
            if (is_file($filename)) {
                $data = @file_get_contents($filename);
                $data= json_decode($data,true);
            }
            // 判断文件的缓存时间是否过期
            if ($data && $data['ctime']+3600 >time()) {
                $isInternal=$data['isInternal'];
            }else{
                // 重置标识
                $data=null;
            }

            if (!$data) {
                // 只需要能连接上到那个端口就行
                //$host='oss-cn-shenzhen.aliyuncs.com';
                $cli = new \GuzzleHttp\Client();
                $bool=false;
                try {
                    $resp = $cli->head("{$scheme}://{$host}",['http_errors'=>false,'timeout'=>0.3,'connect_timeout'=>0.2]);
                    $bool=true;
                } catch (\Exception $exception) {
                }
                if($bool){
                    $isInternal=true;
                }
                // 缓存本次的结果
                file_put_contents($filename,json_encode(['ctime'=>time(),'isInternal'=>$isInternal]));
                chmod($filename,0777);
            }
            // 如果是内网那么重置域名
            if ($isInternal) {
                $this->endpointPrivate = parse_url($this->endpoint,PHP_URL_SCHEME).":://".$host;
                return $this->endpointPrivate;
            }
        }
        return $this->endpoint;
    }
    
    function ping($host, $timeout)
    {
        $port = 0;
        $datasize = 64;
        global $g_icmp_error;
        $g_icmp_error = "No Error";
        $ident = array(ord('J'), ord('C'));
        $seq   = array(rand(0, 255), rand(0, 255));
        
        $packet = '';
        $packet .= chr(8); // type = 8 : request
        $packet .= chr(0); // code = 0
        
        $packet .= chr(0); // checksum init
        $packet .= chr(0); // checksum init
        
        $packet .= chr($ident[0]); // identifier
        $packet .= chr($ident[1]); // identifier
        
        $packet .= chr($seq[0]); // seq
        $packet .= chr($seq[1]); // seq
        
        for ($i = 0; $i < $datasize; $i++)
            $packet .= chr(0);
        
        $chk = $this->icmpChecksum($packet);
        
        $packet[2] = $chk[0]; // checksum init
        $packet[3] = $chk[1]; // checksum init
        
        $sock = socket_create(AF_INET, SOCK_RAW,  getprotobyname('icmp'));
        $time_start = microtime();
        socket_sendto($sock, $packet, strlen($packet), 0, $host, $port);
        
        
        $read   = array($sock);
        $write  = NULL;
        $except = NULL;
        
        $select = socket_select($read, $write, $except, 0, $timeout * 1000);
        if ($select === NULL)
        {
            $g_icmp_error = "Select Error";
            socket_close($sock);
            return -1;
        }
        elseif ($select === 0)
        {
            $g_icmp_error = "Timeout";
            socket_close($sock);
            return -1;
        }
        
        $recv = '';
        $time_stop = microtime();
        socket_recvfrom($sock, $recv, 65535, 0, $host, $port);
        $recv = unpack('C*', $recv);
        
        if ($recv[10] !== 1) // ICMP proto = 1
        {
            $g_icmp_error = "Not ICMP packet";
            socket_close($sock);
            return -1;
        }
        
        if ($recv[21] !== 0) // ICMP response = 0
        {
            $g_icmp_error = "Not ICMP response";
            socket_close($sock);
            return -1;
        }
        
        if ($ident[0] !== $recv[25] || $ident[1] !== $recv[26])
        {
            $g_icmp_error = "Bad identification number";
            socket_close($sock);
            return -1;
        }
        
        if ($seq[0] !== $recv[27] || $seq[1] !== $recv[28])
        {
            $g_icmp_error = "Bad sequence number";
            socket_close($sock);
            return -1;
        }
        
        $ms = ($time_stop - $time_start) * 1000;
        
        if ($ms < 0)
        {
            $g_icmp_error = "Response too long";
            $ms = -1;
        }
        
        socket_close($sock);
        
        return $ms;
    }
    
    function icmpChecksum($data)
    {
        $bit = unpack('n*', $data);
        $sum = array_sum($bit);
        
        if (strlen($data) % 2) {
            $temp = unpack('C*', $data[strlen($data) - 1]);
            $sum += $temp[1];
        }
        
        $sum = ($sum >> 16) + ($sum & 0xffff);
        $sum += ($sum >> 16);
        
        return pack('n*', ~$sum);
    }
    /**
     * @param string $endpoint
     * @return static
     */
    public function setEndpoint($endpoint)
    {
        $this->endpoint = $endpoint;
        return $this;
    }

    /**
     * @return string
     */
    public function getConfigName()
    {
        return $this->configName;
    }

    /**
     * @param string $configName
     */
    public function setConfigName($configName)
    {
        $this->configName = $configName;
        return $this;
    }


    /**
     * @param string $conf
     * @throws OssException
     * @return  static
     */
    abstract  public function setConfig($conf);

    /**
     * 获取一个阿里云的连接对象
     * @return object
     * @throws \OSS\Core\OssException
     */
    abstract public function getClient();
}