<?php


namespace kmkj\help;


use GuzzleHttp\Client;
use kmkj\common\Config;
use kmkj\common\ConfigByPack;

class keyWordException extends \Exception {}

class banWord
{
    /**
     * @var Client
     */
    protected $client;
    
    const BAN_WORD_URI = '/Mobile/XsUtil/getKeyWordsBan';
    const TYPE_BAN = 'bk';
    const TYPE_ALL = 'all';
    
    const TYPE_SENSITIVE = 'rv';
    
    protected $domain = null;
    protected $lastResources;
    public function setDomain($domain){
        $this->domain = $domain;
        return $this;
    }
    protected function getClient(){
        if ($this->client) {
            return $this->client;
        }
        if (!$this->domain) {
            $config =  new ConfigByPack('','app');
            $domain = $config->getConfig('zhitui_domain');
            $this->domain = $domain;
        }
        
        $this->client= new Client(['base_uri'=>rtrim($this->domain)]);
        return   $this->client;
    }
    
    /**
     * @param $txt
     * @param int $limit
     * @return array [{"times":1,"attr":"bk","word":"爆草"},{"times":1,"attr":"rv","word":"精液"}]
     * @User: 阿豹
     * @Date: 2020/7/13
     * @throws keyWordException
     */
    public function getAllWordByBan($txt,$limit=3,$type =null){
        $arr  =[
            'form_params' =>[
                'text' =>$txt,
                'limit' => $limit
            ]
        ];
        try {
            $resp = $this->getClient()->post(static::BAN_WORD_URI,$arr);
            if ($resp->getStatusCode() !== 200) {
                throw new \Exception("调用接口失败");
            }
            $data =json_decode($resp->getBody()->getContents(),true);
            if (!$data || $data['code'] !== 200) {
                throw new keyWordException("解析参数失败");
            }
            $ret = [];
            foreach ($data['data'] as $value) {
                $value['attr'] = trim($value['attr']);
    
                if ($type && $type !=$value['attr']) {
                    continue;
                }
                $ret[] =$value;
            }
            $this->lastResources = $data['data'];
            return $ret;
        } catch (\Exception $exception) {
            throw new keyWordException($exception->getMessage());
        }
    }
    
    /**
     * 获取屏蔽词
     * @param $txt
     * @param $limit
     * @User: 阿豹
     * @Date: 2020/7/13
     * @return array array [{"times":1,"attr":"bk","word":"爆草"},{"times":1,"attr":"rv","word":"精液"}]
     * @throws keyWordException
     */
    public function getBanWord($txt,$limit)
    {
        $data = $this->getAllWordByBan($txt,$limit,static::TYPE_BAN);
        return $data;
    }
    
    /**
     * 获取敏感词
     * @param $txt
     * @param $limit
     * @return array [{"times":1,"attr":"bk","word":"爆草"},{"times":1,"attr":"rv","word":"精液"}]
     * @User: 阿豹
     * @Date: 2020/7/13
     * @throws keyWordException
     */
    public function getSensitiveWord($txt,$limit)
    {
        $data = $this->getAllWordByBan($txt,$limit,static::TYPE_SENSITIVE);
        return $data;
    }
}