<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2020/4/8
 * Time: 4:34 PM
 */

namespace kmkj\common;


/**
 * @author 阿豹
 * 兼容处理  tp3.2 tp5.1 easySwoole 获取配置文件代理类
 *
 * Class Config
 * @package kmkj\common
 */
class Config
{
    /**
     * @var string 配置所属的模块
     */
    protected $module;

    /**
     * @var string
     */
    protected $prefix;

    /**
     * 当前运行在哪一个模块下面
     * @var null |string
     */
    protected  $project =null;

    /**
     * @return null|string
     * @throws \Exception
     */
    public function getProject()
    {
        if ($this->project) {
            return $this->project;
        }
        if(class_exists('\EasySwoole\EasySwoole\Config')){
            $this->project = 'easySwoole';
        } else if (function_exists('M') &&function_exists('A') && function_exists('G') ){
            $this->project = 'tp32';
        }elseif (class_exists('think\app')){
            $this->project = 'tp51';
        }
        else{
            throw new \Exception("没有加载到配置oss配置");
        }
        return $this->project;
    }
    public function __construct($prefix,$module='')
    {
        $this->prefix =  $prefix;
        $this->module =  $module;
    }




    public function getConfig($key){
        switch ($this->getProject()) {
            case 'easySwoole':
                $instance = \EasySwoole\EasySwoole\Config::getInstance();
                return $instance->getConf($this->module.'.'.$this->prefix.'.'.$key);
                break;
            case 'tp51':
                return config($this->module.'.'.$this->prefix.'.'.$key);
                break;
            case 'tp32':
                return C(strtoupper($this->module.'_'.$this->prefix.'_'.$key));
                break;
        }
    }
}