<?php
/**
 * Created by PhpStorm.
 * User: yz520
 * Date: 2019/11/13
 * Time: 4:03 PM
 */

namespace kmkj\mq\consumer;

use kmkj\kmkjtrait\kmkjEventTrait;
use kmkj\mq\ali\aliClient;
use MQ\Model\Message;

class consumer extends aliClient
{

    use kmkjEventTrait;
    protected $currTopic;
    // 获取任务 Error参数 ERROR
    const EVENT_ERROR = 'error';
    // 获取任务失败
    const EVENT_PING = 'ping';
    // 任务完成的回调消息回调参数 Message
    const EVENT_FINISH = 'finish';
    // 消费消息失败了回调参数 Message， \Exception
    const EVENT_ACK_ERROR = 'ackMessageError';

    public function __construct()
    {

        $this->setClient();
        $this->registerEvent(self::EVENT_ACK_ERROR,'default',[$this,'finishError']);
        $this->registerEvent(self::EVENT_ERROR,'default',[$this,'error']);
    }


    /**
     * @var \MQ\MQConsumer
     */
    protected $consumer;
    /**
     * 获取一个消费者对象
     * @param $topic
     * @param string $tag
     * @return \MQ\MQConsumer
     */
    public function getConsumer($topic,$tag=''){
        $this->currTopic = $topic;
        $this->consumer = $this->getClient()->getConsumer($this->mqId,$topic,$this->groupId,$tag);
        return $this->consumer;
    }

    /**
     * @param $event
     * @param int $maxTask
     * @param int $timeOut
     * @return Message|Message[]
     */
    public function listen($event,$maxTask=3,$timeOut=10){

        $event = explode('.',$event);
        while (true) {
            $event[1] = isset($event[1])?$event[1]:'';
            $consumer = $this->getConsumer($event[0],$event[1]);
            $this->triggerEvent(static::EVENT_PING,[]);
            try {
                $messages = $consumer->consumeMessage($maxTask,$timeOut);
            } catch (\Exception $exception) {
                $this->triggerEvent(static::EVENT_ERROR,[$exception]);
                continue;
            }
            return $messages;
        }
    }


    /**
     * 完成一条
     * @param $receiptHandle
     * @param Message $message
     */
    public function finish($receiptHandle,$message=null)
    {
        try {
            $this->consumer->ackMessage([$receiptHandle]);
        } catch (\Exception $e) {
            $this->triggerEvent(static::EVENT_ACK_ERROR,[$e,$message]);
        }

    }

    /**
     * 处理ERROR事件
     * @param \Exception $exception
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2021/08/31 14:02 |变更内容|
     */
    protected function error(\Exception $exception){
        if ($exception instanceof \MQ\Exception\MessageNotExistException) {
            // 没有消息可以消费，接着轮询
            printf("No message, contine long polling!RequestId:%s\n", $exception->getRequestId());
        }
        print_r($exception->getMessage() . "\n");
        sleep(3);
    }
    /**
     * 默认处理消费失败的逻辑
     * @see static::finishAll
     * @see static::finish
     * @param \Exception $e
     * @User: 阿豹
     * @Version
     * |1.0| 阿豹 | 2021/08/31 12:02 |变更内容|
     */
    protected function finishError(\Exception  $e){
        if ($e instanceof \MQ\Exception\AckMessageException) {
            // 某些消息的句柄可能超时了会导致确认不成功
            printf("Ack Error, RequestId:%s\n", $e->getRequestId());
            foreach ($e->getAckMessageErrorItems() as $errorItem) {
                printf("\tReceiptHandle:%s, ErrorCode:%s, ErrorMsg:%s\n", $errorItem->getReceiptHandle(), $errorItem->getErrorCode(), $errorItem->getErrorCode());
            }
            return;
        }
        print_r($e->getMessage() . "\n");
        sleep(3);
    }
    /**
     * 完成所有的任务
     * @param $receiptHandles
     */
    public function finishAll($receiptHandles)
    {
        try {
            $this->consumer->ackMessage($receiptHandles);
        } catch (\Exception $e) {
            $this->triggerEvent(static::EVENT_ACK_ERROR,[$e]);
        }
    }
}